/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.w3c.dom.Element;

@XmlRootElement(name="documentContentUpdate")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentContentUpdateType", propOrder={"applicationContent", "attributeContent", "searchableContent", "attributeDefinitions", "searchableDefinitions", "_futureElements"})
public final class DocumentContentUpdate
extends AbstractDataTransferObject {
    private static final long serialVersionUID = -7386661044232391889L;
    @XmlElement(name="applicationContent", required=false)
    private final String applicationContent;
    @XmlElement(name="attributeContent", required=false)
    private final String attributeContent;
    @XmlElement(name="searchableContent", required=false)
    private final String searchableContent;
    @XmlElementWrapper(name="attributeDefinitions", required=false)
    @XmlElement(name="attributeDefinition", required=false)
    private List<WorkflowAttributeDefinition> attributeDefinitions;
    @XmlElementWrapper(name="searchableDefinitions", required=false)
    @XmlElement(name="searchableDefinition", required=false)
    private List<WorkflowAttributeDefinition> searchableDefinitions;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentContentUpdate() {
        this.applicationContent = null;
        this.attributeContent = null;
        this.searchableContent = null;
        this.attributeDefinitions = null;
        this.searchableDefinitions = null;
    }

    private DocumentContentUpdate(Builder builder) {
        this.applicationContent = builder.getApplicationContent();
        this.attributeContent = builder.getAttributeContent();
        this.searchableContent = builder.getSearchableContent();
        this.attributeDefinitions = builder.getAttributeDefinitions() != null ? new ArrayList<WorkflowAttributeDefinition>(builder.getAttributeDefinitions()) : new ArrayList<WorkflowAttributeDefinition>();
        this.searchableDefinitions = builder.getSearchableDefinitions() != null ? new ArrayList<WorkflowAttributeDefinition>(builder.getSearchableDefinitions()) : new ArrayList<WorkflowAttributeDefinition>();
    }

    public String getApplicationContent() {
        return this.applicationContent;
    }

    public String getAttributeContent() {
        return this.attributeContent;
    }

    public String getSearchableContent() {
        return this.searchableContent;
    }

    public List<WorkflowAttributeDefinition> getAttributeDefinitions() {
        return Collections.unmodifiableList(this.attributeDefinitions);
    }

    public List<WorkflowAttributeDefinition> getSearchableDefinitions() {
        return Collections.unmodifiableList(this.searchableDefinitions);
    }

    static class Elements {
        static final String APPLICATION_CONTENT = "applicationContent";
        static final String ATTRIBUTE_CONTENT = "attributeContent";
        static final String SEARCHABLE_CONTENT = "searchableContent";
        static final String ATTRIBUTE_DEFINITION = "attributeDefinition";
        static final String ATTRIBUTE_DEFINITIONS = "attributeDefinitions";
        static final String SEARCHABLE_DEFINITION = "searchableDefinition";
        static final String SEARCHABLE_DEFINITIONS = "searchableDefinitions";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentContentUpdate";
        static final String TYPE_NAME = "DocumentContentUpdateType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder {
        private static final long serialVersionUID = -1680695196516508680L;
        private String attributeContent = "";
        private String applicationContent = "";
        private String searchableContent = "";
        private List<WorkflowAttributeDefinition> attributeDefinitions = new ArrayList<WorkflowAttributeDefinition>();
        private List<WorkflowAttributeDefinition> searchableDefinitions = new ArrayList<WorkflowAttributeDefinition>();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(DocumentContent documentContent) {
            if (documentContent == null) {
                throw new IllegalArgumentException("documentContent was null");
            }
            Builder builder = Builder.create();
            builder.setAttributeContent(documentContent.getAttributeContent());
            builder.setApplicationContent(documentContent.getApplicationContent());
            builder.setSearchableContent(documentContent.getSearchableContent());
            return builder;
        }

        public static Builder create(DocumentContentUpdate documentContentUpdate) {
            if (documentContentUpdate == null) {
                throw new IllegalArgumentException("documentContentUpdate was null");
            }
            Builder builder = Builder.create();
            builder.setAttributeContent(documentContentUpdate.getAttributeContent());
            builder.setApplicationContent(documentContentUpdate.getApplicationContent());
            builder.setSearchableContent(documentContentUpdate.getSearchableContent());
            builder.setAttributeDefinitions(documentContentUpdate.getAttributeDefinitions());
            builder.setSearchableDefinitions(documentContentUpdate.getSearchableDefinitions());
            return builder;
        }

        public DocumentContentUpdate build() {
            return new DocumentContentUpdate(this);
        }

        public String getAttributeContent() {
            return this.attributeContent;
        }

        public void setAttributeContent(String attributeContent) {
            this.attributeContent = attributeContent;
        }

        public String getApplicationContent() {
            return this.applicationContent;
        }

        public void setApplicationContent(String applicationContent) {
            this.applicationContent = applicationContent;
        }

        public String getSearchableContent() {
            return this.searchableContent;
        }

        public void setSearchableContent(String searchableContent) {
            this.searchableContent = searchableContent;
        }

        public List<WorkflowAttributeDefinition> getAttributeDefinitions() {
            return this.attributeDefinitions;
        }

        public void setAttributeDefinitions(List<WorkflowAttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = attributeDefinitions;
        }

        public List<WorkflowAttributeDefinition> getSearchableDefinitions() {
            return this.searchableDefinitions;
        }

        public void setSearchableDefinitions(List<WorkflowAttributeDefinition> searchableDefinitions) {
            this.searchableDefinitions = searchableDefinitions;
        }
    }
}

