/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeContract;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.api.document.search.DocumentSearchResultContract;
import org.w3c.dom.Element;

@XmlRootElement(name="documentSearchResult")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentSearchResultType", propOrder={"document", "documentAttributes", "_futureElements"})
public final class DocumentSearchResult
extends AbstractDataTransferObject
implements DocumentSearchResultContract {
    @XmlElement(name="document", required=false)
    private final Document document;
    @XmlElementWrapper(name="documentAttributes", required=true)
    @XmlElement(name="documentAttribute", required=false)
    private final List<DocumentAttribute> documentAttributes;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentSearchResult() {
        this.document = null;
        this.documentAttributes = null;
    }

    private DocumentSearchResult(Builder builder) {
        this.document = builder.getDocument().build();
        ArrayList<DocumentAttribute> documentAttributes = new ArrayList<DocumentAttribute>();
        for (DocumentAttribute.AbstractBuilder<?> documentAttribute : builder.getDocumentAttributes()) {
            documentAttributes.add(documentAttribute.build());
        }
        this.documentAttributes = Collections.unmodifiableList(documentAttributes);
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    public List<DocumentAttribute> getDocumentAttributes() {
        return this.documentAttributes;
    }

    public List<DocumentAttribute> getDocumentAttributeByName(String attributeName) {
        ArrayList<DocumentAttribute> namedAttributes = new ArrayList<DocumentAttribute>();
        for (DocumentAttribute attribute : this.getDocumentAttributes()) {
            if (!attribute.getName().equals(attributeName)) continue;
            namedAttributes.add(attribute);
        }
        return Collections.unmodifiableList(namedAttributes);
    }

    public DocumentAttribute getSingleDocumentAttributeByName(String attributeName) {
        List<DocumentAttribute> namedAttributes = this.getDocumentAttributeByName(attributeName);
        if (namedAttributes.isEmpty()) {
            return null;
        }
        return namedAttributes.get(0);
    }

    static class Elements {
        static final String DOCUMENT = "document";
        static final String DOCUMENT_ATTRIBUTES = "documentAttributes";
        static final String DOCUMENT_ATTRIBUTE = "documentAttribute";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentSearchResult";
        static final String TYPE_NAME = "DocumentSearchResultType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    DocumentSearchResultContract {
        private Document.Builder document;
        private List<DocumentAttribute.AbstractBuilder<?>> documentAttributes;

        private Builder(Document.Builder document) {
            this.setDocument(document);
            this.setDocumentAttributes(new ArrayList());
        }

        public static Builder create(Document.Builder document) {
            return new Builder(document);
        }

        public static Builder create(DocumentSearchResultContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Document.Builder documentBuilder = Document.Builder.create(contract.getDocument());
            Builder builder = Builder.create(documentBuilder);
            ArrayList documentAttributes = new ArrayList();
            for (DocumentAttributeContract documentAttributeContract : contract.getDocumentAttributes()) {
                documentAttributes.add(DocumentAttributeFactory.loadContractIntoBuilder(documentAttributeContract));
            }
            builder.setDocumentAttributes(documentAttributes);
            return builder;
        }

        public DocumentSearchResult build() {
            return new DocumentSearchResult(this);
        }

        @Override
        public Document.Builder getDocument() {
            return this.document;
        }

        public List<DocumentAttribute.AbstractBuilder<?>> getDocumentAttributes() {
            return this.documentAttributes;
        }

        public void setDocument(Document.Builder document) {
            if (document == null) {
                throw new IllegalArgumentException("document was null");
            }
            this.document = document;
        }

        public void setDocumentAttributes(List<DocumentAttribute.AbstractBuilder<?>> documentAttributes) {
            this.documentAttributes = documentAttributes;
        }
    }
}

