/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.repository;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.repository.type.KewAttributeDefinition;

public class KewAttributeDefinitionTest
implements GroovyObject {
    private static final String NAMESPACE = "KEW_UNIT_TEST";
    private static final String ID_1 = "1001";
    private static final String ORG_NAME = "ORG";
    private static final String ORG_LABEL = "Organization";
    private static final String COMPONENT = "someOrgComponent";
    private static final Integer SEQUENCE_NUMBER_1;
    private static final String EXPECTED_XML = "\n\t\t<KewAttributeDefinition xmlns=\"http://rice.kuali.org/kew/v2_0\">\n\t\t\t<id>1001</id>\n\t\t\t<name>ORG</name>\n\t\t\t<namespace>KEW_UNIT_TEST</namespace>\n\t\t\t<label>Organization</label>\n\t\t\t<active>1</active>\n\t\t\t<componentName>someOrgComponent</componentName>\n\t\t</KewAttributeDefinition>\n\t";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public KewAttributeDefinitionTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_all_null() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        callSiteArray[0].call(KewAttributeDefinition.Builder.class, null, null, null);
    }

    @Test
    public void test_Builder_create_null_id() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        callSiteArray[1].call(KewAttributeDefinition.Builder.class, null, (Object)ORG_NAME, (Object)NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_id() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        callSiteArray[2].call(KewAttributeDefinition.Builder.class, (Object)"", (Object)ORG_NAME, (Object)NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_id() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        callSiteArray[3].call(KewAttributeDefinition.Builder.class, (Object)"    ", (Object)ORG_NAME, (Object)NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_name() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        callSiteArray[4].call(KewAttributeDefinition.Builder.class, (Object)ID_1, null, (Object)NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty__name() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        callSiteArray[5].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)"", (Object)NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace__name() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        callSiteArray[6].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)"   ", (Object)NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_namespace() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        callSiteArray[7].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)ORG_NAME, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_namespace() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        callSiteArray[8].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)ORG_NAME, (Object)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_namespace() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        callSiteArray[9].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)ORG_NAME, (Object)"    ");
    }

    @Test
    public void test_create_only_required() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        callSiteArray[10].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)ORG_NAME, (Object)NAMESPACE);
    }

    @Test
    public void test_create_and_build_only_required() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        KewAttributeDefinition myDef = (KewAttributeDefinition)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(callSiteArray[12].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)ORG_NAME, (Object)NAMESPACE)), KewAttributeDefinition.class);
        callSiteArray[13].call(Assert.class, (Object)ORG_NAME, callSiteArray[14].call((Object)myDef));
        callSiteArray[15].call(Assert.class, (Object)NAMESPACE, callSiteArray[16].call((Object)myDef));
        callSiteArray[17].call(Assert.class, callSiteArray[18].call((Object)myDef));
    }

    @Test
    public void test_create_and_build_with_label() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        KewAttributeDefinition myDef = (KewAttributeDefinition)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)ORG_NAME, (Object)NAMESPACE), (Object)ORG_LABEL)), KewAttributeDefinition.class);
        callSiteArray[22].call(Assert.class, (Object)ORG_NAME, callSiteArray[23].call((Object)myDef));
        callSiteArray[24].call(Assert.class, (Object)NAMESPACE, callSiteArray[25].call((Object)myDef));
        callSiteArray[26].call(Assert.class, (Object)ORG_LABEL, callSiteArray[27].callGetProperty((Object)myDef));
        callSiteArray[28].call(Assert.class, callSiteArray[29].call((Object)myDef));
    }

    @Test
    public void test_create_and_build_with_component() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        KewAttributeDefinition myDef = (KewAttributeDefinition)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)ORG_NAME, (Object)NAMESPACE), (Object)COMPONENT)), KewAttributeDefinition.class);
        callSiteArray[33].call(Assert.class, (Object)ORG_NAME, callSiteArray[34].call((Object)myDef));
        callSiteArray[35].call(Assert.class, (Object)NAMESPACE, callSiteArray[36].call((Object)myDef));
        callSiteArray[37].call(Assert.class, (Object)COMPONENT, callSiteArray[38].callGetProperty((Object)myDef));
        callSiteArray[39].call(Assert.class, callSiteArray[40].call((Object)myDef));
    }

    @Test
    public void test_create_and_build_with_label_and_component_fluent() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        KewAttributeDefinition myDef = (KewAttributeDefinition)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)ORG_NAME, (Object)NAMESPACE), (Object)ORG_LABEL), (Object)COMPONENT)), KewAttributeDefinition.class);
        callSiteArray[45].call(Assert.class, (Object)ORG_NAME, callSiteArray[46].call((Object)myDef));
        callSiteArray[47].call(Assert.class, (Object)NAMESPACE, callSiteArray[48].call((Object)myDef));
        callSiteArray[49].call(Assert.class, (Object)ORG_LABEL, callSiteArray[50].callGetProperty((Object)myDef));
        callSiteArray[51].call(Assert.class, (Object)COMPONENT, callSiteArray[52].callGetProperty((Object)myDef));
        callSiteArray[53].call(Assert.class, callSiteArray[54].call((Object)myDef));
    }

    @Test
    public void test_create_and_build_with_label_and_component() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        KewAttributeDefinition.Builder myBuilder = (KewAttributeDefinition.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)ORG_NAME, (Object)NAMESPACE), KewAttributeDefinition.Builder.class);
        callSiteArray[56].call((Object)myBuilder, (Object)ORG_LABEL);
        callSiteArray[57].call((Object)myBuilder, (Object)COMPONENT);
        KewAttributeDefinition myDef = (KewAttributeDefinition)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].call((Object)myBuilder), KewAttributeDefinition.class);
        callSiteArray[59].call(Assert.class, (Object)ORG_NAME, callSiteArray[60].call((Object)myDef));
        callSiteArray[61].call(Assert.class, (Object)NAMESPACE, callSiteArray[62].call((Object)myDef));
        callSiteArray[63].call(Assert.class, (Object)ORG_LABEL, callSiteArray[64].callGetProperty((Object)myDef));
        callSiteArray[65].call(Assert.class, (Object)COMPONENT, callSiteArray[66].callGetProperty((Object)myDef));
        callSiteArray[67].call(Assert.class, callSiteArray[68].call((Object)myDef));
    }

    @Test
    public void testXmlMarshaling() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        KewAttributeDefinition myAttr = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[69].callStatic(KewAttributeDefinitionTest.class);
            myAttr = (KewAttributeDefinition)ScriptBytecodeAdapter.castToType((Object)object, KewAttributeDefinition.class);
        } else {
            KewAttributeDefinition kewAttributeDefinition;
            myAttr = kewAttributeDefinition = KewAttributeDefinitionTest.buildFullKewAttributeDefinition();
        }
        JAXBContext jc = (JAXBContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call(JAXBContext.class, KewAttributeDefinition.class), JAXBContext.class);
        Marshaller marshaller = (Marshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].call((Object)jc), Marshaller.class);
        StringWriter sw = (StringWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callConstructor(StringWriter.class), StringWriter.class);
        callSiteArray[73].call((Object)marshaller, callSiteArray[74].callGetProperty(Marshaller.class), (Object)true);
        callSiteArray[75].call((Object)marshaller, (Object)myAttr, (Object)sw);
        String xml = ShortTypeHandling.castToString((Object)callSiteArray[76].call((Object)sw));
        callSiteArray[77].callCurrent((GroovyObject)this, (Object)xml);
        Unmarshaller unmarshaller = (Unmarshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].call((Object)jc), Unmarshaller.class);
        Object actual = callSiteArray[79].call((Object)unmarshaller, callSiteArray[80].callConstructor(StringReader.class, (Object)xml));
        Object expected = callSiteArray[81].call((Object)unmarshaller, callSiteArray[82].callConstructor(StringReader.class, (Object)EXPECTED_XML));
        callSiteArray[83].call(Assert.class, expected, actual);
    }

    public static KewAttributeDefinition buildFullKewAttributeDefinition() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        KewAttributeDefinition myAttr = (KewAttributeDefinition)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].call(callSiteArray[85].call(callSiteArray[86].call(callSiteArray[87].call(KewAttributeDefinition.Builder.class, (Object)ID_1, (Object)ORG_NAME, (Object)NAMESPACE), (Object)ORG_LABEL), (Object)COMPONENT)), KewAttributeDefinition.class);
        return myAttr;
    }

    @Test
    public void testXmlUnmarshal() {
        CallSite[] callSiteArray = KewAttributeDefinitionTest.$getCallSiteArray();
        JAXBContext jc = (JAXBContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[88].call(JAXBContext.class, KewAttributeDefinition.class), JAXBContext.class);
        Unmarshaller unmarshaller = (Unmarshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].call((Object)jc), Unmarshaller.class);
        KewAttributeDefinition myAttr = (KewAttributeDefinition)ScriptBytecodeAdapter.castToType((Object)callSiteArray[90].call((Object)unmarshaller, callSiteArray[91].callConstructor(StringReader.class, (Object)EXPECTED_XML)), KewAttributeDefinition.class);
        callSiteArray[92].call(Assert.class, (Object)ID_1, callSiteArray[93].callGetProperty((Object)myAttr));
        callSiteArray[94].call(Assert.class, (Object)ORG_NAME, callSiteArray[95].callGetProperty((Object)myAttr));
        callSiteArray[96].call(Assert.class, (Object)NAMESPACE, callSiteArray[97].callGetProperty((Object)myAttr));
        callSiteArray[98].call(Assert.class, (Object)ORG_LABEL, callSiteArray[99].callGetProperty((Object)myAttr));
        callSiteArray[100].call(Assert.class, (Object)COMPONENT, callSiteArray[101].callGetProperty((Object)myAttr));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KewAttributeDefinitionTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = KewAttributeDefinitionTest.$getCallSiteArray()[102].callConstructor(Integer.class, (Object)1);
        SEQUENCE_NUMBER_1 = (Integer)ScriptBytecodeAdapter.castToType((Object)object, Integer.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "create";
        stringArray[1] = "create";
        stringArray[2] = "create";
        stringArray[3] = "create";
        stringArray[4] = "create";
        stringArray[5] = "create";
        stringArray[6] = "create";
        stringArray[7] = "create";
        stringArray[8] = "create";
        stringArray[9] = "create";
        stringArray[10] = "create";
        stringArray[11] = "build";
        stringArray[12] = "create";
        stringArray[13] = "assertEquals";
        stringArray[14] = "getName";
        stringArray[15] = "assertEquals";
        stringArray[16] = "getNamespace";
        stringArray[17] = "assertTrue";
        stringArray[18] = "isActive";
        stringArray[19] = "build";
        stringArray[20] = "label";
        stringArray[21] = "create";
        stringArray[22] = "assertEquals";
        stringArray[23] = "getName";
        stringArray[24] = "assertEquals";
        stringArray[25] = "getNamespace";
        stringArray[26] = "assertEquals";
        stringArray[27] = "label";
        stringArray[28] = "assertTrue";
        stringArray[29] = "isActive";
        stringArray[30] = "build";
        stringArray[31] = "componentName";
        stringArray[32] = "create";
        stringArray[33] = "assertEquals";
        stringArray[34] = "getName";
        stringArray[35] = "assertEquals";
        stringArray[36] = "getNamespace";
        stringArray[37] = "assertEquals";
        stringArray[38] = "componentName";
        stringArray[39] = "assertTrue";
        stringArray[40] = "isActive";
        stringArray[41] = "build";
        stringArray[42] = "componentName";
        stringArray[43] = "label";
        stringArray[44] = "create";
        stringArray[45] = "assertEquals";
        stringArray[46] = "getName";
        stringArray[47] = "assertEquals";
        stringArray[48] = "getNamespace";
        stringArray[49] = "assertEquals";
        stringArray[50] = "label";
        stringArray[51] = "assertEquals";
        stringArray[52] = "componentName";
        stringArray[53] = "assertTrue";
        stringArray[54] = "isActive";
        stringArray[55] = "create";
        stringArray[56] = "setLabel";
        stringArray[57] = "setComponentName";
        stringArray[58] = "build";
        stringArray[59] = "assertEquals";
        stringArray[60] = "getName";
        stringArray[61] = "assertEquals";
        stringArray[62] = "getNamespace";
        stringArray[63] = "assertEquals";
        stringArray[64] = "label";
        stringArray[65] = "assertEquals";
        stringArray[66] = "componentName";
        stringArray[67] = "assertTrue";
        stringArray[68] = "isActive";
        stringArray[69] = "buildFullKewAttributeDefinition";
        stringArray[70] = "newInstance";
        stringArray[71] = "createMarshaller";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "setProperty";
        stringArray[74] = "JAXB_FORMATTED_OUTPUT";
        stringArray[75] = "marshal";
        stringArray[76] = "toString";
        stringArray[77] = "print";
        stringArray[78] = "createUnmarshaller";
        stringArray[79] = "unmarshal";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "unmarshal";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "assertEquals";
        stringArray[84] = "build";
        stringArray[85] = "componentName";
        stringArray[86] = "label";
        stringArray[87] = "create";
        stringArray[88] = "newInstance";
        stringArray[89] = "createUnmarshaller";
        stringArray[90] = "unmarshal";
        stringArray[91] = "<$constructor$>";
        stringArray[92] = "assertEquals";
        stringArray[93] = "id";
        stringArray[94] = "assertEquals";
        stringArray[95] = "name";
        stringArray[96] = "assertEquals";
        stringArray[97] = "namespace";
        stringArray[98] = "assertEquals";
        stringArray[99] = "label";
        stringArray[100] = "assertEquals";
        stringArray[101] = "componentName";
        stringArray[102] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[103];
        KewAttributeDefinitionTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(KewAttributeDefinitionTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = KewAttributeDefinitionTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

