/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.repository;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.repository.type.KewTypeAttribute;

public class KewTypeAttributeTest
implements GroovyObject {
    private static final String NAMESPACE = "KEW_UNIT_TEST";
    private static final String ID = "ORG_ATTR_1";
    private static final String TYPE_ID = "1234ABCD";
    private static final String ATTR_DEF_ID = "1001";
    private static final Integer SEQUENCE_NUMBER_1;
    private static final String ORG_NAME = "ORG";
    private static final String ORG_LABEL = "Organization";
    private static final String COMPONENT = "someOrgComponent";
    private static final String EXPECTED_XML = "\n\t\t<KewTypeAttribute xmlns=\"http://rice.kuali.org/kew/v2_0\">\n\t\t\t<id>ORG_ATTR_1</id>\n\t\t\t<typeId>1234ABCD</typeId>\n\t\t\t<attributeDefinitionId>1001</attributeDefinitionId>\n\t\t\t<sequenceNumber>1</sequenceNumber>\n\t\t\t<active>1</active>\n\t\t</KewTypeAttribute>\n\t";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public KewTypeAttributeTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_all_null() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[0].call(KewTypeAttribute.Builder.class, null, null, null, null);
    }

    @Test
    public void test_Builder_create_null_id() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[1].call(KewTypeAttribute.Builder.class, null, (Object)TYPE_ID, (Object)ATTR_DEF_ID, (Object)SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_id() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[2].call(KewTypeAttribute.Builder.class, (Object)"", (Object)TYPE_ID, (Object)ATTR_DEF_ID, (Object)SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_id() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[3].call(KewTypeAttribute.Builder.class, (Object)"    ", (Object)TYPE_ID, (Object)ATTR_DEF_ID, (Object)SEQUENCE_NUMBER_1);
    }

    @Test
    public void test_Builder_create_null_type_id() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[4].call(KewTypeAttribute.Builder.class, null, null, (Object)ATTR_DEF_ID, (Object)SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty__type_id() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[5].call(KewTypeAttribute.Builder.class, (Object)ID, (Object)"", (Object)ATTR_DEF_ID, (Object)SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace__type_id() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[6].call(KewTypeAttribute.Builder.class, (Object)ID, (Object)"   ", (Object)ATTR_DEF_ID, (Object)SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_attr_def_id() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[7].call(KewTypeAttribute.Builder.class, (Object)ID, (Object)TYPE_ID, null, (Object)SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_empty_attr_def_id() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[8].call(KewTypeAttribute.Builder.class, (Object)ID, (Object)TYPE_ID, (Object)"", (Object)SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_whitespace_attr_def_id() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[9].call(KewTypeAttribute.Builder.class, (Object)ID, (Object)TYPE_ID, (Object)"    ", (Object)SEQUENCE_NUMBER_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_sequence_number() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[10].call(KewTypeAttribute.Builder.class, (Object)ID, (Object)TYPE_ID, (Object)ATTR_DEF_ID, null);
    }

    @Test
    public void test_create_only_required() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        callSiteArray[11].call(KewTypeAttribute.Builder.class, (Object)ID, (Object)TYPE_ID, (Object)ATTR_DEF_ID, (Object)SEQUENCE_NUMBER_1);
    }

    @Test
    public void test_create_and_build_only_required() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        KewTypeAttribute myAttr = (KewTypeAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].call(callSiteArray[13].call(KewTypeAttribute.Builder.class, (Object)ID, (Object)TYPE_ID, (Object)ATTR_DEF_ID, (Object)SEQUENCE_NUMBER_1)), KewTypeAttribute.class);
        callSiteArray[14].call(Assert.class, (Object)ID, callSiteArray[15].call((Object)myAttr));
        callSiteArray[16].call(Assert.class, (Object)TYPE_ID, callSiteArray[17].call((Object)myAttr));
        callSiteArray[18].call(Assert.class, (Object)ATTR_DEF_ID, callSiteArray[19].call((Object)myAttr));
        callSiteArray[20].call(Assert.class, (Object)SEQUENCE_NUMBER_1, callSiteArray[21].call((Object)myAttr));
        callSiteArray[22].call(Assert.class, callSiteArray[23].call((Object)myAttr));
    }

    @Test
    public void testXmlMarshaling() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        KewTypeAttribute myAttr = (KewTypeAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call(callSiteArray[25].call(KewTypeAttribute.Builder.class, (Object)ID, (Object)TYPE_ID, (Object)ATTR_DEF_ID, (Object)SEQUENCE_NUMBER_1)), KewTypeAttribute.class);
        JAXBContext jc = (JAXBContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].call(JAXBContext.class, KewTypeAttribute.class), JAXBContext.class);
        Marshaller marshaller = (Marshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call((Object)jc), Marshaller.class);
        StringWriter sw = (StringWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].callConstructor(StringWriter.class), StringWriter.class);
        callSiteArray[29].call((Object)marshaller, (Object)myAttr, (Object)sw);
        String xml = ShortTypeHandling.castToString((Object)callSiteArray[30].call((Object)sw));
        Unmarshaller unmarshaller = (Unmarshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].call((Object)jc), Unmarshaller.class);
        Object actual = callSiteArray[32].call((Object)unmarshaller, callSiteArray[33].callConstructor(StringReader.class, (Object)xml));
        Object expected = callSiteArray[34].call((Object)unmarshaller, callSiteArray[35].callConstructor(StringReader.class, (Object)EXPECTED_XML));
        callSiteArray[36].call(Assert.class, expected, actual);
    }

    @Test
    public void testXmlUnmarshal() {
        CallSite[] callSiteArray = KewTypeAttributeTest.$getCallSiteArray();
        JAXBContext jc = (JAXBContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].call(JAXBContext.class, KewTypeAttribute.class), JAXBContext.class);
        Unmarshaller unmarshaller = (Unmarshaller)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].call((Object)jc), Unmarshaller.class);
        KewTypeAttribute myAttr = (KewTypeAttribute)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call((Object)unmarshaller, callSiteArray[40].callConstructor(StringReader.class, (Object)EXPECTED_XML)), KewTypeAttribute.class);
        callSiteArray[41].call(Assert.class, (Object)ID, callSiteArray[42].callGetProperty((Object)myAttr));
        callSiteArray[43].call(Assert.class, (Object)TYPE_ID, callSiteArray[44].callGetProperty((Object)myAttr));
        callSiteArray[45].call(Assert.class, (Object)ATTR_DEF_ID, callSiteArray[46].callGetProperty((Object)myAttr));
        callSiteArray[47].call(Assert.class, (Object)SEQUENCE_NUMBER_1, callSiteArray[48].callGetProperty((Object)myAttr));
        callSiteArray[49].call(Assert.class, callSiteArray[50].callGetProperty((Object)myAttr));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KewTypeAttributeTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = KewTypeAttributeTest.$getCallSiteArray()[51].callConstructor(Integer.class, (Object)1);
        SEQUENCE_NUMBER_1 = (Integer)ScriptBytecodeAdapter.castToType((Object)object, Integer.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "create";
        stringArray[1] = "create";
        stringArray[2] = "create";
        stringArray[3] = "create";
        stringArray[4] = "create";
        stringArray[5] = "create";
        stringArray[6] = "create";
        stringArray[7] = "create";
        stringArray[8] = "create";
        stringArray[9] = "create";
        stringArray[10] = "create";
        stringArray[11] = "create";
        stringArray[12] = "build";
        stringArray[13] = "create";
        stringArray[14] = "assertEquals";
        stringArray[15] = "getId";
        stringArray[16] = "assertEquals";
        stringArray[17] = "getTypeId";
        stringArray[18] = "assertEquals";
        stringArray[19] = "getAttributeDefinitionId";
        stringArray[20] = "assertEquals";
        stringArray[21] = "getSequenceNumber";
        stringArray[22] = "assertTrue";
        stringArray[23] = "isActive";
        stringArray[24] = "build";
        stringArray[25] = "create";
        stringArray[26] = "newInstance";
        stringArray[27] = "createMarshaller";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "marshal";
        stringArray[30] = "toString";
        stringArray[31] = "createUnmarshaller";
        stringArray[32] = "unmarshal";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "unmarshal";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "assertEquals";
        stringArray[37] = "newInstance";
        stringArray[38] = "createUnmarshaller";
        stringArray[39] = "unmarshal";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "assertEquals";
        stringArray[42] = "id";
        stringArray[43] = "assertEquals";
        stringArray[44] = "typeId";
        stringArray[45] = "assertEquals";
        stringArray[46] = "attributeDefinitionId";
        stringArray[47] = "assertEquals";
        stringArray[48] = "sequenceNumber";
        stringArray[49] = "assertTrue";
        stringArray[50] = "active";
        stringArray[51] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[52];
        KewTypeAttributeTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(KewTypeAttributeTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = KewTypeAttributeTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

