/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.validation;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.core.test.JAXBAssert;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.rule.RuleDelegation;
import org.kuali.rice.kew.api.validation.RuleValidationContext;
import org.kuali.rice.kew.api.validation.RuleValidationContextContract;

public class RuleValidationContextTest
implements GroovyObject {
    private static final String RULE = "\n        <ns3:rule>\n            <active>true</active>\n            <forceAction>false</forceAction>\n            <ruleExtensionMap/>\n        </ns3:rule>\n        ";
    private static final String RVC;
    private static final String RVC_RULE_ONLY;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public RuleValidationContextTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = RuleValidationContextTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_rule() {
        CallSite[] callSiteArray = RuleValidationContextTest.$getCallSiteArray();
        callSiteArray[0].call(RuleValidationContext.Builder.class, null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_Builder_create_fail_null_source() {
        CallSite[] callSiteArray = RuleValidationContextTest.$getCallSiteArray();
        callSiteArray[1].call(RuleValidationContext.Builder.class, (Object)ScriptBytecodeAdapter.createPojoWrapper(null, RuleContract.class));
    }

    @Test(expected=NullPointerException.class)
    public void test_Builder_create_fail_null_source2() {
        CallSite[] callSiteArray = RuleValidationContextTest.$getCallSiteArray();
        callSiteArray[2].call(RuleValidationContext.Builder.class, (Object)ScriptBytecodeAdapter.createPojoWrapper(null, RuleValidationContextContract.class));
    }

    @Test
    public void test_Builder_create_success_optional_properties() {
        CallSite[] callSiteArray = RuleValidationContextTest.$getCallSiteArray();
        Rule rule = (Rule)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(callSiteArray[4].call(Rule.Builder.class)), Rule.class);
        RuleValidationContext ctx = (RuleValidationContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call(callSiteArray[6].call(RuleValidationContext.Builder.class, (Object)rule, null, null)), RuleValidationContext.class);
        callSiteArray[7].call(Assert.class, (Object)rule, callSiteArray[8].call((Object)ctx));
        callSiteArray[9].call(Assert.class, callSiteArray[10].call((Object)ctx));
        callSiteArray[11].call(Assert.class, callSiteArray[12].call((Object)ctx));
    }

    @Test
    public void test_Builder_create_success() {
        CallSite[] callSiteArray = RuleValidationContextTest.$getCallSiteArray();
        Rule rule = (Rule)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].call(callSiteArray[14].call(Rule.Builder.class)), Rule.class);
        RuleDelegation ruleDelegation = (RuleDelegation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call(callSiteArray[16].call(RuleDelegation.Builder.class)), RuleDelegation.class);
        String principalId = "principalId";
        RuleValidationContext ctx = (RuleValidationContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call(callSiteArray[18].call(RuleValidationContext.Builder.class, (Object)rule, (Object)ruleDelegation, (Object)principalId)), RuleValidationContext.class);
        callSiteArray[19].call(Assert.class, (Object)rule, callSiteArray[20].call((Object)ctx));
        callSiteArray[21].call(Assert.class, (Object)ruleDelegation, callSiteArray[22].call((Object)ctx));
        callSiteArray[23].call(Assert.class, (Object)principalId, callSiteArray[24].call((Object)ctx));
    }

    @Test
    public void test_Builder_create_copy_success() {
        CallSite[] callSiteArray = RuleValidationContextTest.$getCallSiteArray();
        Rule rule = (Rule)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call(callSiteArray[26].call(Rule.Builder.class)), Rule.class);
        RuleDelegation ruleDelegation = (RuleDelegation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call(callSiteArray[28].call(RuleDelegation.Builder.class)), RuleDelegation.class);
        String principalId = "principalId";
        Object src = callSiteArray[29].call(callSiteArray[30].call(RuleValidationContext.Builder.class, (Object)rule, (Object)ruleDelegation, (Object)principalId));
        Object ctx = callSiteArray[31].call(callSiteArray[32].call(RuleValidationContext.Builder.class, src));
        callSiteArray[33].call(Assert.class, (Object)rule, callSiteArray[34].call(ctx));
        callSiteArray[35].call(Assert.class, (Object)ruleDelegation, callSiteArray[36].call(ctx));
        callSiteArray[37].call(Assert.class, (Object)principalId, callSiteArray[38].call(ctx));
    }

    @Test
    @Ignore
    public void test_Xml_Marshal_Unmarshal() {
        CallSite[] callSiteArray = RuleValidationContextTest.$getCallSiteArray();
        Rule rule = (Rule)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call(callSiteArray[40].call(Rule.Builder.class, (Object)"ruleName")), Rule.class);
        RuleDelegation ruleDelegation = (RuleDelegation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call(callSiteArray[42].call(RuleDelegation.Builder.class)), RuleDelegation.class);
        String principalId = "principalId";
        Object ctx = callSiteArray[43].call(callSiteArray[44].call(RuleValidationContext.Builder.class, (Object)rule, (Object)ruleDelegation, (Object)principalId));
        callSiteArray[45].call(JAXBAssert.class, ctx, (Object)RVC, RuleValidationContext.class);
    }

    @Test
    @Ignore
    public void test_Xml_Marshal_Unmarshal_just_rule() {
        CallSite[] callSiteArray = RuleValidationContextTest.$getCallSiteArray();
        Rule rule = (Rule)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call(callSiteArray[47].call(Rule.Builder.class, (Object)"ruleName")), Rule.class);
        Object ctx = callSiteArray[48].call(callSiteArray[49].call(RuleValidationContext.Builder.class, (Object)rule, null, null));
        callSiteArray[50].call(JAXBAssert.class, ctx, (Object)RVC_RULE_ONLY, RuleValidationContext.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RuleValidationContextTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        GStringImpl gStringImpl = new GStringImpl(new Object[]{RULE}, new String[]{"\n        <ns3:ruleValidationContext xmlns:ns2=\"http://rice.kuali.org/core/v2_0\" xmlns:ns3=\"http://rice.kuali.org/kew/v2_0\">\n            ", "\n            <ns3:ruleDelegation/>\n            <ns3:ruleAuthorPrincipalId>principalId</ns3:ruleAuthorPrincipalId>\n \t \t</ns3:ruleValidationContext>\n \t \t"});
        RVC = ShortTypeHandling.castToString((Object)gStringImpl);
        GStringImpl gStringImpl2 = new GStringImpl(new Object[]{RULE}, new String[]{"\n        <ns3:ruleValidationContext xmlns:ns2=\"http://rice.kuali.org/core/v2_0\" xmlns:ns3=\"http://rice.kuali.org/kew/v2_0\">\n            ", "\n \t \t</ns3:ruleValidationContext>\n \t \t"});
        RVC_RULE_ONLY = ShortTypeHandling.castToString((Object)gStringImpl2);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "create";
        stringArray[1] = "create";
        stringArray[2] = "create";
        stringArray[3] = "build";
        stringArray[4] = "create";
        stringArray[5] = "build";
        stringArray[6] = "create";
        stringArray[7] = "assertEquals";
        stringArray[8] = "getRule";
        stringArray[9] = "assertNull";
        stringArray[10] = "getRuleDelegation";
        stringArray[11] = "assertNull";
        stringArray[12] = "getRuleAuthorPrincipalId";
        stringArray[13] = "build";
        stringArray[14] = "create";
        stringArray[15] = "build";
        stringArray[16] = "create";
        stringArray[17] = "build";
        stringArray[18] = "create";
        stringArray[19] = "assertEquals";
        stringArray[20] = "getRule";
        stringArray[21] = "assertEquals";
        stringArray[22] = "getRuleDelegation";
        stringArray[23] = "assertEquals";
        stringArray[24] = "getRuleAuthorPrincipalId";
        stringArray[25] = "build";
        stringArray[26] = "create";
        stringArray[27] = "build";
        stringArray[28] = "create";
        stringArray[29] = "build";
        stringArray[30] = "create";
        stringArray[31] = "build";
        stringArray[32] = "create";
        stringArray[33] = "assertEquals";
        stringArray[34] = "getRule";
        stringArray[35] = "assertEquals";
        stringArray[36] = "getRuleDelegation";
        stringArray[37] = "assertEquals";
        stringArray[38] = "getRuleAuthorPrincipalId";
        stringArray[39] = "build";
        stringArray[40] = "create";
        stringArray[41] = "build";
        stringArray[42] = "create";
        stringArray[43] = "build";
        stringArray[44] = "create";
        stringArray[45] = "assertEqualXmlMarshalUnmarshal";
        stringArray[46] = "build";
        stringArray[47] = "create";
        stringArray[48] = "build";
        stringArray[49] = "create";
        stringArray[50] = "assertEqualXmlMarshalUnmarshal";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[51];
        RuleValidationContextTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(RuleValidationContextTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = RuleValidationContextTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

