/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document;

import java.math.BigDecimal;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.document.DocumentLink;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentStatusTransition;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;

@WebService(name="workflowDocumentService", targetNamespace="http://rice.kuali.org/kew/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface WorkflowDocumentService {
    @WebMethod(operationName="getDocument")
    @WebResult(name="document")
    public Document getDocument(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="doesDocumentExist")
    @WebResult(name="document")
    public boolean doesDocumentExist(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDocumentContent")
    @WebResult(name="documentContent")
    public DocumentContent getDocumentContent(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDocumentTypeName")
    @WebResult(name="documentTypeName")
    public String getDocumentTypeName(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRootActionRequests")
    @XmlElementWrapper(name="rootActionRequests", required=true)
    @XmlElement(name="rootActionRequest", required=false)
    @WebResult(name="rootActionRequests")
    public List<ActionRequest> getRootActionRequests(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPendingActionRequests")
    @XmlElementWrapper(name="pendingActionRequests", required=true)
    @XmlElement(name="pendingActionRequest", required=false)
    @WebResult(name="pendingActionRequests")
    public List<ActionRequest> getPendingActionRequests(String var1);

    @WebMethod(operationName="getActionRequestsForPrincipalAtNode")
    @XmlElementWrapper(name="actionRequests", required=true)
    @XmlElement(name="actionRequests", required=false)
    @WebResult(name="actionRequests")
    public List<ActionRequest> getActionRequestsForPrincipalAtNode(@WebParam(name="documentId") String var1, @WebParam(name="nodeName") String var2, @WebParam(name="principalId") String var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getActionsTaken")
    @XmlElementWrapper(name="actionsTaken", required=true)
    @XmlElement(name="actionTaken", required=false)
    @WebResult(name="actionsTaken")
    public List<ActionTaken> getActionsTaken(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getActionRequests")
    @XmlElementWrapper(name="actionsTaken", required=true)
    @XmlElement(name="actionTaken", required=false)
    @WebResult(name="actionsTaken")
    @Deprecated
    public List<ActionTaken> _getActionsTaken(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAllActionRequests")
    @XmlElementWrapper(name="actionsTaken", required=true)
    @XmlElement(name="actionTaken", required=false)
    @WebResult(name="actionsTaken")
    public List<ActionTaken> getAllActionsTaken(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDocumentDetailByAppId")
    @WebResult(name="documentDetail")
    public DocumentDetail getDocumentDetailByAppId(@WebParam(name="documentTypeName") String var1, @WebParam(name="appId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDocumentDetail")
    @WebResult(name="documentDetail")
    public DocumentDetail getDocumentDetail(@WebParam(name="documentId") String var1);

    @WebMethod(operationName="getRouteNodeInstance")
    @WebResult(name="routeNodeInstance")
    public RouteNodeInstance getRouteNodeInstance(@WebParam(name="routeNodeInstanceId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getApplicationDocumentId")
    @WebResult(name="applicationDocumentId")
    public String getApplicationDocumentId(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getApplicationDocumentStatus")
    @WebResult(name="applicationDocumentStatus")
    public String getApplicationDocumentStatus(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="documentSearch")
    @WebResult(name="documentSearchResults")
    public DocumentSearchResults documentSearch(@WebParam(name="principalId") String var1, @WebParam(name="criteria") DocumentSearchCriteria var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="documentSearchSaveable")
    @WebResult(name="documentSearchResults")
    public DocumentSearchResults documentSearchSaveable(@WebParam(name="principalId") String var1, @WebParam(name="criteria") DocumentSearchCriteria var2, @WebParam(name="saveSearch") boolean var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRouteNodeInstances")
    @XmlElementWrapper(name="routeNodeInstances", required=true)
    @XmlElement(name="routeNodeInstance", required=false)
    @WebResult(name="routeNodeInstances")
    public List<RouteNodeInstance> getRouteNodeInstances(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getActiveRouteNodeInstances")
    @XmlElementWrapper(name="routeNodeInstances", required=true)
    @XmlElement(name="routeNodeInstance", required=false)
    @WebResult(name="routeNodeInstances")
    public List<RouteNodeInstance> getActiveRouteNodeInstances(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getTerminalRouteNodeInstances")
    @XmlElementWrapper(name="routeNodeInstances", required=true)
    @XmlElement(name="routeNodeInstance", required=false)
    @WebResult(name="routeNodeInstances")
    public List<RouteNodeInstance> getTerminalRouteNodeInstances(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getCurrentRouteNodeInstances")
    @XmlElementWrapper(name="routeNodeInstances", required=true)
    @XmlElement(name="routeNodeInstance", required=false)
    @WebResult(name="routeNodeInstances")
    public List<RouteNodeInstance> getCurrentRouteNodeInstances(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPreviousRouteNodeNames")
    @XmlElementWrapper(name="previousRouteNodeNames", required=true)
    @XmlElement(name="previousRouteNodeName", required=false)
    @WebResult(name="previousRouteNodeNames")
    public List<String> getPreviousRouteNodeNames(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDocumentStatus")
    @WebResult(name="documentStatus")
    public DocumentStatus getDocumentStatus(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPrincipalIdsWithPendingActionRequestByActionRequestedAndDocId")
    @XmlElementWrapper(name="principalIds", required=true)
    @XmlElement(name="principalId", required=false)
    @WebResult(name="principalIds")
    public List<String> getPrincipalIdsWithPendingActionRequestByActionRequestedAndDocId(@WebParam(name="actionRequestedCd") String var1, @WebParam(name="documentId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDocumentInitiatorPrincipalId")
    @WebResult(name="principalId")
    public String getDocumentInitiatorPrincipalId(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoutedByPrincipalIdByDocumentId")
    @WebResult(name="principalId")
    public String getRoutedByPrincipalIdByDocumentId(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getSearchableAttributeStringValuesByKey")
    @XmlElementWrapper(name="searchableAttributeStringValues", required=true)
    @XmlElement(name="searchableAttributeStringValue", required=false)
    @WebResult(name="searchableAttributeStringValues")
    public List<String> getSearchableAttributeStringValuesByKey(@WebParam(name="documentId") String var1, @WebParam(name="key") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getSearchableAttributeDateTimeValuesByKey")
    @XmlElementWrapper(name="searchableAttributeDateTimeValues", required=true)
    @XmlElement(name="searchableAttributeDateTimeValue", required=false)
    @WebResult(name="searchableAttributeDateTimeValues")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    public List<DateTime> getSearchableAttributeDateTimeValuesByKey(@WebParam(name="documentId") String var1, @WebParam(name="key") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getSearchableAttributeFloatValuesByKey")
    @XmlElementWrapper(name="searchableAttributeBigDecimalValues", required=true)
    @XmlElement(name="searchableAttributeBigDecimalValue", required=false)
    @WebResult(name="searchableAttributeBigDecimalValues")
    public List<BigDecimal> getSearchableAttributeFloatValuesByKey(@WebParam(name="documentId") String var1, @WebParam(name="key") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getSearchableAttributeLongValuesByKey")
    @XmlElementWrapper(name="searchableAttributeLongValues", required=true)
    @XmlElement(name="searchableAttributeLongValue", required=false)
    @WebResult(name="searchableAttributeLongValues")
    public List<Long> getSearchableAttributeLongValuesByKey(@WebParam(name="documentId") String var1, @WebParam(name="key") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDocumentStatusTransitionHistory")
    @XmlElementWrapper(name="documentStatusTransitions", required=true)
    @XmlElement(name="documentStatusTransition", required=false)
    @WebResult(name="documentStatusTransitions")
    public List<DocumentStatusTransition> getDocumentStatusTransitionHistory(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="addDocumentLink")
    @WebResult(name="documentLink")
    public DocumentLink addDocumentLink(@WebParam(name="documentLink") DocumentLink var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteDocumentLink")
    @WebResult(name="documentLink")
    public DocumentLink deleteDocumentLink(@WebParam(name="documentLinkId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteDocumentLinksByDocumentId")
    @XmlElementWrapper(name="documentLinks", required=true)
    @XmlElement(name="documentLink", required=false)
    @WebResult(name="documentLinks")
    public List<DocumentLink> deleteDocumentLinksByDocumentId(@WebParam(name="originatingDocumentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getOutgoingDocumentLinks")
    @XmlElementWrapper(name="documentLinks", required=true)
    @XmlElement(name="documentLink", required=false)
    @WebResult(name="documentLinks")
    public List<DocumentLink> getOutgoingDocumentLinks(@WebParam(name="originatingDocumentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getIncomingDocumentLinks")
    @XmlElementWrapper(name="documentLinks", required=true)
    @XmlElement(name="documentLink", required=false)
    @WebResult(name="documentLinks")
    public List<DocumentLink> getIncomingDocumentLinks(@WebParam(name="originatingDocumentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDocumentLink")
    @WebResult(name="documentLinks")
    public DocumentLink getDocumentLink(@WebParam(name="documentLinkId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getActiveRouteNodeNames")
    @XmlElementWrapper(name="nodes", required=true)
    @XmlElement(name="node", required=false)
    @WebResult(name="nodes")
    public List<String> getActiveRouteNodeNames(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getActiveSimpleRouteNodeNames")
    @XmlElementWrapper(name="nodes", required=true)
    @XmlElement(name="node", required=false)
    @WebResult(name="nodes")
    public List<String> getActiveSimpleRouteNodeNames(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getTerminalRouteNodeNames")
    @XmlElementWrapper(name="nodes", required=true)
    @XmlElement(name="node", required=false)
    @WebResult(name="nodes")
    public List<String> getTerminalRouteNodeNames(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getCurrentRouteNodeNames")
    @XmlElementWrapper(name="nodes", required=true)
    @XmlElement(name="node", required=false)
    @WebResult(name="nodes")
    public List<String> getCurrentRouteNodeNames(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getCurrentSimpleRouteNodeNames")
    @XmlElementWrapper(name="nodes", required=true)
    @XmlElement(name="node", required=false)
    @WebResult(name="nodes")
    public List<String> getCurrentSimpleRouteNodeNames(@WebParam(name="documentId") String var1) throws RiceIllegalArgumentException;
}

