/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document.attribute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.document.PropertyDefinition;
import org.w3c.dom.Element;

@XmlRootElement(name="workflowAttributeDefinition")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="WorkflowAttributeDefinitionType", propOrder={"attributeName", "parameters", "propertyDefinitions", "_futureElements"})
public final class WorkflowAttributeDefinition
extends AbstractDataTransferObject {
    @XmlElement(name="attributeName", required=true)
    private final String attributeName;
    @XmlElementWrapper(name="parameters", required=false)
    @XmlElement(name="parameter", required=false)
    private final List<String> parameters;
    @XmlElementWrapper(name="propertyDefinitions", required=false)
    @XmlElement(name="propertyDefinition", required=false)
    private final List<PropertyDefinition> propertyDefinitions;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private WorkflowAttributeDefinition() {
        this.attributeName = null;
        this.parameters = null;
        this.propertyDefinitions = null;
    }

    private WorkflowAttributeDefinition(Builder builder) {
        this.attributeName = builder.getAttributeName();
        this.parameters = builder.getParameters() == null ? Collections.emptyList() : new ArrayList<String>(builder.getParameters());
        this.propertyDefinitions = builder.getPropertyDefinitions() == null ? Collections.emptyList() : new ArrayList<PropertyDefinition>(builder.getPropertyDefinitions());
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public List<String> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public List<PropertyDefinition> getPropertyDefinitions() {
        return Collections.unmodifiableList(this.propertyDefinitions);
    }

    public Map<String, String> getPropertyDefinitionsAsMap() {
        HashMap<String, String> propertiesDefinitionsMap = new HashMap<String, String>();
        for (PropertyDefinition propertyDefinition : this.getPropertyDefinitions()) {
            propertiesDefinitionsMap.put(propertyDefinition.getName(), propertyDefinition.getValue());
        }
        return Collections.unmodifiableMap(propertiesDefinitionsMap);
    }

    static class Elements {
        static final String ATTRIBUTE_NAME = "attributeName";
        static final String PARAMETERS = "parameters";
        static final String PARAMETER = "parameter";
        static final String PROPERTY_DEFINITIONS = "propertyDefinitions";
        static final String PROPERTY_DEFINITION = "propertyDefinition";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "workflowAttributeDefinition";
        static final String TYPE_NAME = "WorkflowAttributeDefinitionType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder {
        private static final long serialVersionUID = 7549637048594326790L;
        private String attributeName;
        private List<String> parameters;
        private List<PropertyDefinition> propertyDefinitions;

        private Builder(String attributeName) {
            this.setAttributeName(attributeName);
            this.setParameters(new ArrayList<String>());
            this.setPropertyDefinitions(new ArrayList<PropertyDefinition>());
        }

        private Builder(WorkflowAttributeDefinition definition) {
            this.setAttributeName(definition.getAttributeName());
            this.setParameters(definition.getParameters());
            this.setPropertyDefinitions(definition.getPropertyDefinitions());
        }

        public static Builder create(WorkflowAttributeDefinition definition) {
            if (definition == null) {
                throw new IllegalArgumentException("definition was null");
            }
            return new Builder(definition);
        }

        public static Builder create(String attributeName) {
            return new Builder(attributeName);
        }

        public WorkflowAttributeDefinition build() {
            return new WorkflowAttributeDefinition(this);
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public List<String> getParameters() {
            return this.parameters;
        }

        public List<PropertyDefinition> getPropertyDefinitions() {
            return this.propertyDefinitions;
        }

        public void setAttributeName(String attributeName) {
            if (StringUtils.isBlank((String)attributeName)) {
                throw new IllegalArgumentException("attributeName was null or blank");
            }
            this.attributeName = attributeName;
        }

        public void addParameter(String parameter) {
            this.parameters.add(parameter);
        }

        public void removeParameter(String parameter) {
            this.parameters.remove(parameter);
        }

        public void setParameters(List<String> parameters) {
            this.parameters = new ArrayList<String>(parameters);
        }

        public void addPropertyDefinition(PropertyDefinition propertyDefinition) {
            if (propertyDefinition == null) {
                throw new IllegalArgumentException("propertyDefinition must be non-null.");
            }
            this.propertyDefinitions.add(propertyDefinition);
        }

        public void setPropertyDefinitions(List<PropertyDefinition> propertyDefinitions) {
            if (propertyDefinitions == null) {
                this.setPropertyDefinitions(new ArrayList<PropertyDefinition>());
            }
            this.propertyDefinitions = new ArrayList<PropertyDefinition>(propertyDefinitions);
        }

        public void addPropertyDefinition(String name, String value) {
            this.addPropertyDefinition(PropertyDefinition.create(name, value));
        }

        public PropertyDefinition getPropertyDefinition(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name was null or blank");
            }
            for (PropertyDefinition propertyDefinition : this.propertyDefinitions) {
                if (!propertyDefinition.equals(name)) continue;
                return propertyDefinition;
            }
            return null;
        }
    }
}

