/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.action;

/**
 * Specifies a set of Action codes.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ActionSetContract {

    public boolean hasAction(String actionCode);
    public boolean addAction(String actionCode);
    public boolean removeAction(String actionCode);
    public boolean hasApprove();
    public boolean hasComplete();
    public boolean hasAcknowledge();
    public boolean hasFyi();
    public boolean hasDisapprove();
    public boolean hasCancel();
    public boolean hasRouted();
    public boolean addApprove();
    public boolean addComplete();
    public boolean addAcknowledge();
    public boolean addFyi();
    public boolean addDisapprove();    
    public boolean addCancel();
    public boolean addRouted();
    
}
