/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.exception;

/**
 * A generic checked exception thrown from KEW.  Acts as the superclass for all checked
 * exceptions in KEW.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class WorkflowException extends Exception {

	private static final long serialVersionUID = 4377433160795253501L;

	public WorkflowException() {
		super();
	}

	public WorkflowException(String message) {
		super(message);
	}

	public WorkflowException(String message, Throwable throwable) {
		super(message, throwable);
	}

	public WorkflowException(Throwable throwable) {
		super(throwable);
	}

}
