/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.exception;


/**
 * Thrown when a resource is not available.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ResourceUnavailableException extends WorkflowException {

	private static final long serialVersionUID = -6217074085963406965L;

	public ResourceUnavailableException() {
        super();
    }

    public ResourceUnavailableException(String message) {
        super(message);
    }

    public ResourceUnavailableException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public ResourceUnavailableException(Throwable throwable) {
        super(throwable);
    }

}
