/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.identity;

import org.kuali.rice.kew.api.user.UserId;

/**
 * The primary ID of a Principal in KIM
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class PrincipalId implements UserId {
    private static final long serialVersionUID = -5551723348738932404L;

    private String principalId;

	public PrincipalId() { }

	public PrincipalId(String principalId) {
		setPrincipalId(principalId);
	}
	
	public String getPrincipalId() {
		return this.principalId;
	}
	
	public void setPrincipalId(String principalId) {
		this.principalId = (principalId == null ? null : principalId.trim());
	}

    @Override
    public String getId() {
        return getPrincipalId();
    }


    /**
     * Returns true if this userId has an empty value. Empty userIds can't be used as keys in a Hash, among other things.
     *
     * @return true if this instance doesn't have a value
     */
    @Override
    public boolean isEmpty() {
    	return (principalId == null || principalId.trim().length() == 0);
    }

    /**
     * If you make this class non-final, you must rewrite equals to work for subclasses.
     */
    @Override
    public boolean equals(Object obj) {
        if (obj != null && (obj instanceof PrincipalId)) {
            PrincipalId w = (PrincipalId) obj;

            if (getPrincipalId() == null) {
                return false;
            }
            return principalId.equals(w.getPrincipalId());
        }

        return false;
    }

    @Override
    public int hashCode() {
        return principalId == null ? 0 : principalId.hashCode();
    }

    @Override
    public String toString() {
        if (principalId == null) {
            return "principalId: null";
        }
        return "principalId: " + principalId;
    }

}
