/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.rule;

import org.kuali.rice.core.api.delegation.DelegationType;

public interface RuleDelegationContract {

    /**
     * type of delegation for the RuleDelegation
     *
     * <p>Determines what kind of delegation the RuleDelegation is</p>
     *
     * @return delegationType
     */
    DelegationType getDelegationType();

    /**
     * rule associated with the RuleDelegation
     *
     * <p>This rule is run for the original rule as the delegate</p>
     *
     * @return delegationRule
     */
    RuleContract getDelegationRule();
}
