/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.action;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.KewApiConstants;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;

/**
 * Defines the contract for a message queue which can invoke requested workflow actions against an action item on a
 * document.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@WebService(name = "actionInvocationQueue", targetNamespace = KewApiConstants.Namespaces.KEW_NAMESPACE_2_0)
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, parameterStyle = SOAPBinding.ParameterStyle.WRAPPED)
public interface ActionInvocationQueue {

    @WebMethod(operationName = "invokeAction")
	void invokeAction(
            @WebParam(name = "principalId") String principalId,
            @WebParam(name = "documentId") String documentId,
            @WebParam(name = "actionInvocation") ActionInvocation actionInvocation)
        throws RiceIllegalArgumentException;
    
}
