/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.action;

import org.kuali.rice.kew.api.actionlist.DisplayParameters;

/**
 * Contract interface for action item customizations
 */
public interface ActionItemCustomizationContract {

    /**
     * Gets the ID of the action item this customization is for
     * @return the action item id.  Never null.
     */
    String getActionItemId();

    /**
     * Gets the display parameters in this action item customization.
     * @return the display parameters.  May be null.
     */
    DisplayParameters getDisplayParameters();

    /**
     * Gets the set of actions in this action item customization.
     * @return the action set.  Never null.
     */
    ActionSet getActionSet();
}
