/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.identity;

import java.io.Serializable;

/**
 * Superinterface of UserId and GroupId
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface Id extends Serializable {
    /**
     * Returns true if this Id has an empty value. Empty Ids can't be used as keys in a Hash,
     * among other things.
     *
     * @return true if this instance doesn't have a value
     */
    public boolean isEmpty();
}
