/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.document.DocumentContentContract;
import org.w3c.dom.Element;

@XmlRootElement(name="documentContent")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentContentType", propOrder={"documentId", "applicationContent", "attributeContent", "searchableContent", "formatVersion", "_futureElements"})
public final class DocumentContent
extends AbstractDataTransferObject
implements DocumentContentContract {
    private static final long serialVersionUID = 6110079520547685342L;
    @XmlElement(name="documentId", required=true)
    private final String documentId;
    @XmlElement(name="applicationContent", required=false)
    private final String applicationContent;
    @XmlElement(name="attributeContent", required=false)
    private final String attributeContent;
    @XmlElement(name="searchableContent", required=false)
    private final String searchableContent;
    @XmlElement(name="formatVersion", required=true)
    private final int formatVersion;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentContent() {
        this.documentId = null;
        this.applicationContent = null;
        this.attributeContent = null;
        this.searchableContent = null;
        this.formatVersion = 0;
    }

    private DocumentContent(Builder builder) {
        this.documentId = builder.getDocumentId();
        this.applicationContent = builder.getApplicationContent();
        this.attributeContent = builder.getAttributeContent();
        this.searchableContent = builder.getSearchableContent();
        this.formatVersion = builder.getFormatVersion();
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public String getApplicationContent() {
        return this.applicationContent;
    }

    @Override
    public String getAttributeContent() {
        return this.attributeContent;
    }

    @Override
    public String getSearchableContent() {
        return this.searchableContent;
    }

    @Override
    public int getFormatVersion() {
        return this.formatVersion;
    }

    public String getFullContent() {
        StringBuilder fullContent = new StringBuilder();
        fullContent.append("<").append("documentContent").append(">");
        if (!StringUtils.isBlank((String)this.getApplicationContent())) {
            fullContent.append("<").append("applicationContent").append(">");
            fullContent.append(this.getApplicationContent());
            fullContent.append("</").append("applicationContent").append(">");
        }
        if (!StringUtils.isBlank((String)this.getAttributeContent())) {
            fullContent.append(this.getAttributeContent());
        }
        if (!StringUtils.isBlank((String)this.getSearchableContent())) {
            fullContent.append(this.getSearchableContent());
        }
        fullContent.append("</").append("documentContent").append(">");
        return fullContent.toString();
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    DocumentContentContract {
        private static final long serialVersionUID = 7549637048594326790L;
        private String documentId;
        private String applicationContent;
        private String attributeContent;
        private String searchableContent;
        private int formatVersion;

        private Builder(String documentId) {
            this.setDocumentId(documentId);
            this.setFormatVersion(1);
        }

        public static Builder create(String documentId) {
            return new Builder(documentId);
        }

        public static Builder create(DocumentContentContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getDocumentId());
            builder.setApplicationContent(contract.getApplicationContent());
            builder.setAttributeContent(contract.getAttributeContent());
            builder.setSearchableContent(contract.getSearchableContent());
            builder.setFormatVersion(contract.getFormatVersion());
            return builder;
        }

        public DocumentContent build() {
            return new DocumentContent(this);
        }

        @Override
        public String getDocumentId() {
            return this.documentId;
        }

        @Override
        public String getApplicationContent() {
            return this.applicationContent;
        }

        @Override
        public String getAttributeContent() {
            return this.attributeContent;
        }

        @Override
        public String getSearchableContent() {
            return this.searchableContent;
        }

        @Override
        public int getFormatVersion() {
            return this.formatVersion;
        }

        public void setDocumentId(String documentId) {
            if (StringUtils.isBlank((String)documentId)) {
                throw new IllegalArgumentException("documentId was null or blank");
            }
            this.documentId = documentId;
        }

        public void setApplicationContent(String applicationContent) {
            this.applicationContent = applicationContent;
        }

        public void setAttributeContent(String attributeContent) {
            this.attributeContent = attributeContent;
        }

        public void setSearchableContent(String searchableContent) {
            this.searchableContent = searchableContent;
        }

        public void setFormatVersion(int formatVersion) {
            if (formatVersion < 0) {
                throw new IllegalArgumentException("formatVersion must be a valid version, was " + formatVersion);
            }
            this.formatVersion = formatVersion;
        }
    }

    static class Elements {
        static final String DOCUMENT_ID = "documentId";
        static final String APPLICATION_CONTENT = "applicationContent";
        static final String ATTRIBUTE_CONTENT = "attributeContent";
        static final String SEARCHABLE_CONTENT = "searchableContent";
        static final String FORMAT_VERSION = "formatVersion";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentContent";
        static final String TYPE_NAME = "DocumentContentType";

        Constants() {
        }
    }
}

