/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.peopleflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowContract;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowMember;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowMemberContract;
import org.w3c.dom.Element;

@XmlRootElement(name="peopleFlowDefinition")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="PeopleFlowDefinitionType", propOrder={"id", "namespaceCode", "name", "typeId", "description", "members", "attributes", "active", "versionNumber", "_futureElements"})
public final class PeopleFlowDefinition
extends AbstractDataTransferObject
implements PeopleFlowContract {
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> attributes;
    @XmlElement(name="namespaceCode", required=true)
    private final String namespaceCode;
    @XmlElement(name="typeId", required=false)
    private final String typeId;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElementWrapper(name="members", required=false)
    @XmlElement(name="member", required=false)
    private final List<PeopleFlowMember> members;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private PeopleFlowDefinition() {
        this.name = null;
        this.attributes = null;
        this.namespaceCode = null;
        this.typeId = null;
        this.description = null;
        this.members = null;
        this.id = null;
        this.active = false;
        this.versionNumber = null;
    }

    private PeopleFlowDefinition(Builder builder) {
        this.name = builder.getName();
        this.attributes = builder.getAttributes();
        this.namespaceCode = builder.getNamespaceCode();
        this.typeId = builder.getTypeId();
        this.description = builder.getDescription();
        this.members = ModelObjectUtils.buildImmutableCopy(builder.getMembers());
        this.id = builder.getId();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public List<PeopleFlowMember> getMembers() {
        return this.members;
    }

    public String getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    PeopleFlowContract {
        private String name;
        private Map<String, String> attributes;
        private String namespaceCode;
        private String typeId;
        private String description;
        private List<PeopleFlowMember.Builder> members;
        private String id;
        private boolean active;
        private Long versionNumber;

        private Builder(String namespaceCode, String name) {
            this.setNamespaceCode(namespaceCode);
            this.setName(name);
            this.setActive(true);
            this.setAttributes(new HashMap<String, String>());
            this.setMembers(new ArrayList<PeopleFlowMember.Builder>());
        }

        public static Builder create(String namespaceCode, String name) {
            return new Builder(namespaceCode, name);
        }

        public static Builder create(PeopleFlowContract contract) {
            Builder builder = Builder.createCopy(contract);
            builder.setVersionNumber(contract.getVersionNumber());
            if (contract.getMembers() != null) {
                for (PeopleFlowMemberContract peopleFlowMemberContract : contract.getMembers()) {
                    builder.getMembers().add(PeopleFlowMember.Builder.create(peopleFlowMemberContract));
                }
            }
            return builder;
        }

        private static Builder createCopy(PeopleFlowContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getNamespaceCode(), contract.getName());
            if (contract.getAttributes() != null) {
                builder.getAttributes().putAll(contract.getAttributes());
            }
            if (StringUtils.isEmpty((String)contract.getTypeId())) {
                builder.setTypeId(null);
            } else {
                builder.setTypeId(contract.getTypeId());
            }
            builder.setDescription(contract.getDescription());
            builder.setId(contract.getId());
            builder.setActive(contract.isActive());
            return builder;
        }

        public static Builder createMaintenanceCopy(PeopleFlowContract contract) {
            Builder builder = Builder.createCopy(contract);
            if (contract.getMembers() != null) {
                for (PeopleFlowMemberContract peopleFlowMemberContract : contract.getMembers()) {
                    builder.getMembers().add(PeopleFlowMember.Builder.createCopy(peopleFlowMemberContract));
                }
            }
            return builder;
        }

        public PeopleFlowDefinition build() {
            return new PeopleFlowDefinition(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public String getNamespaceCode() {
            return this.namespaceCode;
        }

        @Override
        public String getTypeId() {
            return this.typeId;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public List<PeopleFlowMember.Builder> getMembers() {
            return this.members;
        }

        public String getId() {
            return this.id;
        }

        public boolean isActive() {
            return this.active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name was null or blank");
            }
            this.name = name;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public void setNamespaceCode(String namespaceCode) {
            if (StringUtils.isBlank((String)namespaceCode)) {
                throw new IllegalArgumentException("namespaceCode was null or blank");
            }
            this.namespaceCode = namespaceCode;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setMembers(List<PeopleFlowMember.Builder> members) {
            this.members = members;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public PeopleFlowMember.Builder addPrincipal(String principalId) {
            PeopleFlowMember.Builder member = PeopleFlowMember.Builder.create(principalId, MemberType.PRINCIPAL);
            this.getMembers().add(member);
            return member;
        }

        public PeopleFlowMember.Builder addGroup(String groupId) {
            PeopleFlowMember.Builder member = PeopleFlowMember.Builder.create(groupId, MemberType.GROUP);
            this.getMembers().add(member);
            return member;
        }

        public PeopleFlowMember.Builder addRole(String roleId) {
            PeopleFlowMember.Builder member = PeopleFlowMember.Builder.create(roleId, MemberType.ROLE);
            this.getMembers().add(member);
            return member;
        }
    }

    static class Elements {
        static final String NAME = "name";
        static final String ATTRIBUTES = "attributes";
        static final String NAMESPACE_CODE = "namespaceCode";
        static final String TYPE_ID = "typeId";
        static final String DESCRIPTION = "description";
        static final String MEMBERS = "members";
        static final String MEMBER = "member";
        static final String ID = "id";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "peopleFlowDefinition";
        static final String TYPE_NAME = "PeopleFlowDefinitionType";

        Constants() {
        }
    }
}

