/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.exception;

import org.kuali.rice.kew.api.WorkflowRuntimeException;

/**
 * An exception which is thrown when a pessimistic lock fails to be aquired.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class LockingException extends WorkflowRuntimeException {

    /**
	 * 
	 */
	private static final long serialVersionUID = -8604582895083027695L;
	public LockingException() {
        super();
   }
    public LockingException(String message) {
        super(message);
    }
    public LockingException(String message, Throwable cause) {
        super(message, cause);
    }
    public LockingException(Throwable cause) {
        super(cause);
    }
    
}
