/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.framework.document.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeContract;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultValueContract;
import org.w3c.dom.Element;

@XmlRootElement(name="documentSearchResultValue")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentSearchResultValueType", propOrder={"documentId", "documentAttributes", "_futureElements"})
public final class DocumentSearchResultValue
extends AbstractDataTransferObject
implements DocumentSearchResultValueContract {
    @XmlElement(name="documentId", required=true)
    private final String documentId;
    @XmlElementWrapper(name="documentAttributes", required=false)
    @XmlElement(name="documentAttribute", required=false)
    private final List<DocumentAttribute> documentAttributes;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentSearchResultValue() {
        this.documentId = null;
        this.documentAttributes = null;
    }

    private DocumentSearchResultValue(Builder builder) {
        this.documentId = builder.getDocumentId();
        this.documentAttributes = ModelObjectUtils.buildImmutableCopy(builder.getDocumentAttributes());
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    public List<DocumentAttribute> getDocumentAttributes() {
        return this.documentAttributes;
    }

    static class Elements {
        static final String DOCUMENT_ID = "documentId";
        static final String DOCUMENT_ATTRIBUTES = "documentAttributes";
        static final String DOCUMENT_ATTRIBUTE = "documentAttribute";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentSearchResultValue";
        static final String TYPE_NAME = "DocumentSearchResultValueType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    DocumentSearchResultValueContract {
        private String documentId;
        private List<DocumentAttribute.AbstractBuilder<?>> documentAttributes;

        private Builder(String documentId) {
            this.setDocumentId(documentId);
            this.setDocumentAttributes(new ArrayList());
        }

        public static Builder create(String documentId) {
            return new Builder(documentId);
        }

        public static Builder create(DocumentSearchResultValueContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getDocumentId());
            if (contract.getDocumentAttributes() != null) {
                for (DocumentAttributeContract documentAttributeContract : contract.getDocumentAttributes()) {
                    builder.getDocumentAttributes().add(DocumentAttributeFactory.loadContractIntoBuilder((DocumentAttributeContract)documentAttributeContract));
                }
            }
            return builder;
        }

        public DocumentSearchResultValue build() {
            return new DocumentSearchResultValue(this);
        }

        @Override
        public String getDocumentId() {
            return this.documentId;
        }

        public List<DocumentAttribute.AbstractBuilder<?>> getDocumentAttributes() {
            return this.documentAttributes;
        }

        public void setDocumentId(String documentId) {
            if (StringUtils.isBlank((String)documentId)) {
                throw new IllegalArgumentException("documentId was null or blank");
            }
            this.documentId = documentId;
        }

        public void setDocumentAttributes(List<DocumentAttribute.AbstractBuilder<?>> documentAttributes) {
            this.documentAttributes = documentAttributes;
        }
    }
}

