/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.postprocessor;


public class DocumentRouteLevelChange implements IDocumentEvent {
	
	// TODO for now we will include the new node-based routing fields onto this object to avoid an interface
	// change to the PostProcessor interface.
	
  private static final long serialVersionUID = 785552701611174468L;

  private String documentId;
  private String appDocId;
  private Integer oldRouteLevel;
  private Integer newRouteLevel;
  private String oldNodeName;
  private String newNodeName;
  private String oldNodeInstanceId;
  private String newNodeInstanceId;
  
  //  this constructor is for backwards compatibility
  public DocumentRouteLevelChange(String documentId, String appDocId, Integer oldRouteLevel, Integer newRouteLevel) {
	  this(documentId, appDocId, oldRouteLevel, newRouteLevel, null, null, null, null);
  }
  
  public DocumentRouteLevelChange(String documentId, String appDocId, Integer oldRouteLevel,
    Integer newRouteLevel, String oldNodeName, String newNodeName, String oldNodeInstanceId, String newNodeInstanceId) {
    this.documentId = documentId;
    this.oldRouteLevel = oldRouteLevel;
    this.newRouteLevel = newRouteLevel;
    this.oldNodeName = oldNodeName;
    this.newNodeName = newNodeName;
    this.oldNodeInstanceId = oldNodeInstanceId;
    this.newNodeInstanceId = newNodeInstanceId;
    this.appDocId = appDocId;
  }

  @Override
  public String getDocumentEventCode() {
    return ROUTE_LEVEL_CHANGE;
  }

  @Override
  public String getDocumentId() {
    return documentId;
  }

  public Integer getOldRouteLevel() {
    return oldRouteLevel;
  }

  public Integer getNewRouteLevel() {
    return newRouteLevel;
  }

  public String getNewNodeInstanceId() {
	return newNodeInstanceId;
  }

  public String getNewNodeName() {
	return newNodeName;
  }

  public String getOldNodeInstanceId() {
	return oldNodeInstanceId;
  }

  public String getOldNodeName() {
	return oldNodeName;
  }

  @Override
  public String toString() {
    StringBuffer buffer = new StringBuffer();
    buffer.append("DocumentId ").append(documentId);
    buffer.append(" changing from routeLevel ").append(oldRouteLevel);
    buffer.append(" to routeLevel ").append(newRouteLevel);

    return buffer.toString();
  }

  /**
   * @return
   */
  @Override
  public String getAppDocId() {
    return appDocId;
  }
}
