/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.postprocessor;

/**
 * Event sent to the postprocessor when the processor is ended
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class AfterProcessEvent implements IDocumentEvent {

	private static final long serialVersionUID = 2945081851810845704L;
	private String documentId;
	private String appDocId;
	private boolean successfullyProcessed;

	public AfterProcessEvent(String documentId, String appDocId, boolean successfullyProcessed) {
		this.documentId = documentId;
		this.appDocId = appDocId;
		this.successfullyProcessed = successfullyProcessed;
	}

	@Override
    public String getDocumentId() {
		return documentId;
	}

	@Override
    public String getAppDocId() {
		return appDocId;
	}
	
    public boolean isSuccessfullyProcessed() {
        return this.successfullyProcessed;
    }

    @Override
    public String getDocumentEventCode() {
        return IDocumentEvent.AFTER_PROCESS;
    }

}
