/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.peopleflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDefinition;
import org.kuali.rice.kew.api.repository.type.KewTypeDefinition;
import org.kuali.rice.kew.framework.peopleflow.PeopleFlowTypeService;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowBo;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowMemberBo;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;

public class PeopleFlowMaintainableImpl
extends MaintainableImpl {
    protected int addLine(Collection<Object> collection, Object addLine, boolean insertFirst) {
        if (collection instanceof List) {
            ((List)collection).add(0, addLine);
            if (addLine instanceof PeopleFlowMemberBo) {
                PeopleFlowMemberBo member = (PeopleFlowMemberBo)addLine;
                if (member.getMemberType() != MemberType.ROLE) {
                    member.setActionRequestPolicyCode(null);
                }
                Collections.sort((List)collection, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof PeopleFlowMemberBo && o1 instanceof PeopleFlowMemberBo) {
                            return ((PeopleFlowMemberBo)o1).getPriority() - ((PeopleFlowMemberBo)o2).getPriority();
                        }
                        return 0;
                    }
                });
            }
        } else {
            collection.add(addLine);
        }
        int index = 0;
        for (Object element : collection) {
            if (element == addLine) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public List<RemotableAttributeField> retrieveTypeAttributes(View view, Object model, Container container) {
        List<Object> remoteFields = new ArrayList<RemotableAttributeField>();
        PeopleFlowBo peopleFlow = (PeopleFlowBo)((MaintenanceDocumentForm)model).getDocument().getNewMaintainableObject().getDataObject();
        String typeId = peopleFlow.getTypeId();
        if (StringUtils.isNotBlank((String)typeId)) {
            KewTypeDefinition typeDefinition = KewApiServiceLocator.getKewTypeRepositoryService().getTypeById(typeId);
            PeopleFlowTypeService peopleFlowTypeService = (PeopleFlowTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(typeDefinition.getServiceName()));
            remoteFields = peopleFlowTypeService.getAttributeFields(typeId);
        }
        return remoteFields;
    }

    public void prepareForSave() {
        ((PeopleFlowBo)this.getDataObject()).updateAttributeBoValues();
    }

    public void processAfterRetrieve() {
        ((PeopleFlowBo)this.getDataObject()).postLoad();
    }

    public void saveDataObject() {
        PeopleFlowDefinition peopleFlowDefinition = "Copy".equals(this.getMaintenanceAction()) ? PeopleFlowBo.maintenanceCopy((PeopleFlowBo)this.getDataObject()) : PeopleFlowBo.to((PeopleFlowBo)this.getDataObject());
        if (StringUtils.isNotBlank((String)peopleFlowDefinition.getId())) {
            KewApiServiceLocator.getPeopleFlowService().updatePeopleFlow(peopleFlowDefinition);
        } else {
            KewApiServiceLocator.getPeopleFlowService().createPeopleFlow(peopleFlowDefinition);
        }
    }

    public void processAfterAddLine(ViewModel model, Object addLine, String collectionId, String collectionPath, boolean isValidLine) {
        if (model instanceof MaintenanceDocumentForm && "Edit".equals(((MaintenanceDocumentForm)model).getMaintenanceAction()) && !(addLine instanceof Note)) {
            Class collectionObjectClass = (Class)model.getViewPostMetadata().getComponentPostData(collectionId, "collectionObjectClass");
            String oldCollectionPath = collectionPath.replace("newMaintainableObject", "oldMaintainableObject");
            Collection oldCollection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)model, (String)oldCollectionPath);
            try {
                Object blankLine = collectionObjectClass.newInstance();
                oldCollection.add(blankLine);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create new line instance for old maintenance object", e);
            }
        }
    }

    public void processCollectionDeleteLine(ViewModel model, String collectionId, String collectionPath, int lineIndex) {
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)model, (String)collectionPath);
        if (collection == null) {
            this.logAndThrowRuntime("Unable to get collection property from model for path: " + collectionPath);
        }
        if (collection instanceof List) {
            Object deleteLine = ((List)collection).get(lineIndex);
            boolean isValid = this.performDeleteLineValidation(model, collectionId, collectionPath, deleteLine);
            if (isValid) {
                ((List)collection).remove(lineIndex);
                this.processAfterDeleteLine(model, collectionId, collectionPath, lineIndex);
            }
        } else {
            this.logAndThrowRuntime("Only List collection implementations are supported for the delete by index method");
        }
    }

    public void processAfterDeleteLine(ViewModel model, String collectionId, String collectionPath, int lineIndex) {
        if (model instanceof MaintenanceDocumentForm && "Edit".equals(((MaintenanceDocumentForm)model).getMaintenanceAction())) {
            String oldCollectionPath = collectionPath.replace("newMaintainableObject", "oldMaintainableObject");
            Collection oldCollection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)model, (String)oldCollectionPath);
            try {
                oldCollection.remove(oldCollection.toArray()[lineIndex]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to delete line instance for old maintenance object", e);
            }
        }
    }
}

