/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.employment;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.KualiDecimalAdapter;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.employment.EntityEmploymentContract;
import org.w3c.dom.Element;

@XmlRootElement(name="entityEmployment")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityEmploymentType", propOrder={"id", "entityId", "employeeId", "employmentRecordId", "entityAffiliation", "employeeStatus", "employeeType", "primaryDepartmentCode", "baseSalaryAmount", "primary", "versionNumber", "objectId", "active", "_futureElements"})
public final class EntityEmployment
extends AbstractDataTransferObject
implements EntityEmploymentContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="entityId", required=false)
    private final String entityId;
    @XmlElement(name="entityAffiliation", required=false)
    private final EntityAffiliation entityAffiliation;
    @XmlElement(name="employeeStatus", required=false)
    private final CodedAttribute employeeStatus;
    @XmlElement(name="employeeType", required=false)
    private final CodedAttribute employeeType;
    @XmlElement(name="primaryDepartmentCode", required=false)
    private final String primaryDepartmentCode;
    @XmlElement(name="employeeId", required=false)
    private final String employeeId;
    @XmlElement(name="employmentRecordId", required=false)
    private final String employmentRecordId;
    @XmlElement(name="baseSalaryAmount", required=false)
    @XmlJavaTypeAdapter(value=KualiDecimalAdapter.class)
    private final KualiDecimal baseSalaryAmount;
    @XmlElement(name="primary", required=false)
    private final boolean primary;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityEmployment() {
        this.entityAffiliation = null;
        this.employeeStatus = null;
        this.employeeType = null;
        this.primaryDepartmentCode = null;
        this.employeeId = null;
        this.employmentRecordId = null;
        this.baseSalaryAmount = null;
        this.primary = false;
        this.versionNumber = null;
        this.objectId = null;
        this.active = false;
        this.entityId = null;
        this.id = null;
    }

    private EntityEmployment(Builder builder) {
        this.entityAffiliation = builder.getEntityAffiliation() != null ? builder.getEntityAffiliation().build() : null;
        this.employeeStatus = builder.getEmployeeStatus() != null ? builder.getEmployeeStatus().build() : null;
        this.employeeType = builder.getEmployeeType() != null ? builder.getEmployeeType().build() : null;
        this.primaryDepartmentCode = builder.getPrimaryDepartmentCode();
        this.employeeId = builder.getEmployeeId();
        this.employmentRecordId = builder.getEmploymentRecordId();
        this.baseSalaryAmount = builder.getBaseSalaryAmount();
        this.primary = builder.isPrimary();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.active = builder.isActive();
        this.id = builder.getId();
        this.entityId = builder.getEntityId();
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public EntityAffiliation getEntityAffiliation() {
        return this.entityAffiliation;
    }

    @Override
    public CodedAttribute getEmployeeStatus() {
        return this.employeeStatus;
    }

    @Override
    public CodedAttribute getEmployeeType() {
        return this.employeeType;
    }

    @Override
    public String getPrimaryDepartmentCode() {
        return this.primaryDepartmentCode;
    }

    @Override
    public String getEmployeeId() {
        return this.employeeId;
    }

    @Override
    public String getEmploymentRecordId() {
        return this.employmentRecordId;
    }

    @Override
    public KualiDecimal getBaseSalaryAmount() {
        return this.baseSalaryAmount;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getId() {
        return this.id;
    }

    static class Elements {
        static final String ENTITY_AFFILIATION = "entityAffiliation";
        static final String EMPLOYEE_STATUS = "employeeStatus";
        static final String EMPLOYEE_TYPE = "employeeType";
        static final String PRIMARY_DEPARTMENT_CODE = "primaryDepartmentCode";
        static final String EMPLOYEE_ID = "employeeId";
        static final String EMPLOYMENT_RECORD_ID = "employmentRecordId";
        static final String BASE_SALARY_AMOUNT = "baseSalaryAmount";
        static final String PRIMARY = "primary";
        static final String ACTIVE = "active";
        static final String ENTITY_ID = "entityId";
        static final String ID = "id";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityEmployment";
        static final String TYPE_NAME = "EntityEmploymentType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    EntityEmploymentContract {
        private String entityId;
        private EntityAffiliation.Builder entityAffiliation;
        private CodedAttribute.Builder employeeStatus;
        private CodedAttribute.Builder employeeType;
        private String primaryDepartmentCode;
        private String employeeId;
        private String employmentRecordId;
        private KualiDecimal baseSalaryAmount;
        private boolean primary;
        private Long versionNumber;
        private String objectId;
        private boolean active;
        private String id;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(EntityEmploymentContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setEntityId(contract.getEntityId());
            if (contract.getEntityAffiliation() != null) {
                builder.setEntityAffiliation(EntityAffiliation.Builder.create(contract.getEntityAffiliation()));
            }
            if (contract.getEmployeeStatus() != null) {
                builder.setEmployeeStatus(CodedAttribute.Builder.create(contract.getEmployeeStatus()));
            }
            if (contract.getEmployeeType() != null) {
                builder.setEmployeeType(CodedAttribute.Builder.create(contract.getEmployeeType()));
            }
            builder.setPrimaryDepartmentCode(contract.getPrimaryDepartmentCode());
            builder.setEmployeeId(contract.getEmployeeId());
            builder.setEmploymentRecordId(contract.getEmploymentRecordId());
            builder.setBaseSalaryAmount(contract.getBaseSalaryAmount());
            builder.setPrimary(contract.isPrimary());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setActive(contract.isActive());
            builder.setId(contract.getId());
            return builder;
        }

        public EntityEmployment build() {
            return new EntityEmployment(this);
        }

        @Override
        public String getEntityId() {
            return this.entityId;
        }

        @Override
        public EntityAffiliation.Builder getEntityAffiliation() {
            return this.entityAffiliation;
        }

        @Override
        public CodedAttribute.Builder getEmployeeStatus() {
            return this.employeeStatus;
        }

        @Override
        public CodedAttribute.Builder getEmployeeType() {
            return this.employeeType;
        }

        @Override
        public String getPrimaryDepartmentCode() {
            return this.primaryDepartmentCode;
        }

        @Override
        public String getEmployeeId() {
            return this.employeeId;
        }

        @Override
        public String getEmploymentRecordId() {
            return this.employmentRecordId;
        }

        @Override
        public KualiDecimal getBaseSalaryAmount() {
            return this.baseSalaryAmount;
        }

        @Override
        public boolean isPrimary() {
            return this.primary;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getId() {
            return this.id;
        }

        public void setEntityAffiliation(EntityAffiliation.Builder entityAffiliation) {
            this.entityAffiliation = entityAffiliation;
        }

        public void setEmployeeStatus(CodedAttribute.Builder employeeStatus) {
            this.employeeStatus = employeeStatus;
        }

        public void setEmployeeType(CodedAttribute.Builder employeeType) {
            this.employeeType = employeeType;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public void setPrimaryDepartmentCode(String primaryDepartmentCode) {
            this.primaryDepartmentCode = primaryDepartmentCode;
        }

        public void setEmployeeId(String employeeId) {
            this.employeeId = employeeId;
        }

        public void setEmploymentRecordId(String employmentRecordId) {
            this.employmentRecordId = employmentRecordId;
        }

        public void setBaseSalaryAmount(KualiDecimal baseSalaryAmount) {
            this.baseSalaryAmount = baseSalaryAmount;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }
    }
}

