/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.role;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kim.api.common.delegate.DelegateMember;
import org.kuali.rice.kim.api.common.delegate.DelegateType;
import org.kuali.rice.kim.api.role.DelegateMemberQueryResults;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleMemberQueryResults;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleMembershipQueryResults;
import org.kuali.rice.kim.api.role.RoleQueryResults;
import org.kuali.rice.kim.api.role.RoleResponsibility;
import org.kuali.rice.kim.api.role.RoleResponsibilityAction;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

@WebService(name="roleService", targetNamespace="http://rice.kuali.org/kim/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface RoleService {
    @WebMethod(operationName="createRole")
    @WebResult(name="role")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public Role createRole(@WebParam(name="role") Role var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateRole")
    @WebResult(name="role")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public Role updateRole(@WebParam(name="role") Role var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="getRole")
    @WebResult(name="role")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleType"}, key="'id=' + #p0")
    public Role getRole(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoles")
    @XmlElementWrapper(name="roles", required=true)
    @XmlElement(name="role", required=false)
    @WebResult(name="roles")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleType"}, key="'ids=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).key(#p0)")
    public List<Role> getRoles(@WebParam(name="ids") List<String> var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoleByNamespaceCodeAndName")
    @WebResult(name="role")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleType"}, key="'namespaceCode=' + #p0 + '|' + 'name=' + #p1")
    public Role getRoleByNamespaceCodeAndName(@WebParam(name="namespaceCode") String var1, @WebParam(name="name") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoleIdByNamespaceCodeAndName")
    @WebResult(name="roleId")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleType"}, key="'{getRoleIdByNamespaceCodeAndName}' + 'namespaceCode=' + #p0 + '|' + 'name=' + #p1")
    public String getRoleIdByNamespaceCodeAndName(@WebParam(name="namespaceCode") String var1, @WebParam(name="name") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isRoleActive")
    @WebResult(name="isRoleActive")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleType"}, key="'{isRoleActive}' + 'id=' + #p0")
    public boolean isRoleActive(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoleQualifersForPrincipalByRoleIds")
    @XmlElementWrapper(name="attributes", required=true)
    @XmlElement(name="attribute", required=false)
    @WebResult(name="attributes")
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    public List<Map<String, String>> getRoleQualifersForPrincipalByRoleIds(@WebParam(name="principalId") String var1, @WebParam(name="roleIds") List<String> var2, @WebParam(name="qualification") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoleQualifersForPrincipalByNamespaceAndRolename")
    @XmlElementWrapper(name="attributes", required=true)
    @XmlElement(name="attribute", required=false)
    @WebResult(name="attributes")
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    public List<Map<String, String>> getRoleQualifersForPrincipalByNamespaceAndRolename(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="roleName") String var3, @WebParam(name="qualification") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getNestedRoleQualifersForPrincipalByNamespaceAndRolename")
    @XmlElementWrapper(name="attributes", required=true)
    @XmlElement(name="attribute", required=false)
    @WebResult(name="attributes")
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    public List<Map<String, String>> getNestedRoleQualifersForPrincipalByNamespaceAndRolename(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="roleName") String var3, @WebParam(name="qualification") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getNestedRoleQualifiersForPrincipalByRoleIds")
    @XmlElementWrapper(name="attributes", required=true)
    @XmlElement(name="attribute", required=false)
    @WebResult(name="attributes")
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    public List<Map<String, String>> getNestedRoleQualifiersForPrincipalByRoleIds(@WebParam(name="principalId") String var1, @WebParam(name="roleIds") List<String> var2, @WebParam(name="qualification") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoleMembers")
    @XmlElementWrapper(name="roleMemberships", required=true)
    @XmlElement(name="roleMembership", required=false)
    @WebResult(name="roleMemberships")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleMemberType"}, key="'roleIds=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).key(#p0) + '|' + 'qualification=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).mapKey(#p1)", condition="!T(org.kuali.rice.kim.api.cache.KimCacheUtils).isDynamicRoleMembership(#p0)")
    public List<RoleMembership> getRoleMembers(@WebParam(name="roleIds") List<String> var1, @WebParam(name="qualification") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoleMemberPrincipalIds")
    @XmlElementWrapper(name="principalIds", required=true)
    @XmlElement(name="principalId", required=false)
    @WebResult(name="principalIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleMemberType"}, key="'namespaceCode=' + #p0 + '|' + 'roleName=' + #p1 + '|' + 'qualification=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).mapKey(#p2)", condition="!T(org.kuali.rice.kim.api.cache.KimCacheUtils).isDynamicMembshipRoleByNamespaceAndName(#p0, #p1)")
    public Collection<String> getRoleMemberPrincipalIds(@WebParam(name="namespaceCode") String var1, @WebParam(name="roleName") String var2, @WebParam(name="qualification") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="principalHasRole")
    @WebResult(name="principalHasRole")
    public boolean principalHasRole(@WebParam(name="principalId") String var1, @WebParam(name="roleIds") List<String> var2, @WebParam(name="qualification") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="principalHasRoleCheckDelegation")
    @WebResult(name="principalHasRoleCheckDelegation")
    public boolean principalHasRole(@WebParam(name="principalId") String var1, @WebParam(name="roleIds") List<String> var2, @WebParam(name="qualification") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var3, boolean var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPrincipalIdSubListWithRole")
    @XmlElementWrapper(name="principalIds", required=true)
    @XmlElement(name="principalId", required=false)
    @WebResult(name="principalIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleMemberType"}, key="'getPrincipalIdSubListWithRole' + 'principalIds=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).key(#p0) + '|' + 'roleNamespaceCode=' + #p1 + '|' + 'roleName=' + #p2 + '|' + 'qualification=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).mapKey(#p3)", condition="!T(org.kuali.rice.kim.api.cache.KimCacheUtils).isDynamicMembshipRoleByNamespaceAndName(#p1, #p2)")
    public List<String> getPrincipalIdSubListWithRole(@WebParam(name="principalIds") List<String> var1, @WebParam(name="roleNamespaceCode") String var2, @WebParam(name="roleName") String var3, @WebParam(name="qualification") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRolesSearchResults")
    @WebResult(name="results")
    public RoleQueryResults findRoles(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getFirstLevelRoleMembers")
    @XmlElementWrapper(name="roleMemberships", required=true)
    @XmlElement(name="roleMembership", required=false)
    @WebResult(name="roleMemberships")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleMembershipType"}, key="'roleIds=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).key(#p0)")
    public List<RoleMembership> getFirstLevelRoleMembers(@WebParam(name="roleIds") List<String> var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findRoleMemberships")
    @WebResult(name="results")
    public RoleMembershipQueryResults findRoleMemberships(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getMemberParentRoleIds")
    @XmlElementWrapper(name="roleIds", required=true)
    @XmlElement(name="roleId", required=false)
    @WebResult(name="roleIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleMembershipType"}, key="'memberType=' + #p0 + '|' + 'memberId=' + #p1")
    public List<String> getMemberParentRoleIds(String var1, String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findRoleMembers")
    @WebResult(name="results")
    public RoleMemberQueryResults findRoleMembers(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoleTypeRoleMemberIds")
    @XmlElementWrapper(name="memberIds", required=true)
    @XmlElement(name="memberId", required=false)
    @WebResult(name="memberIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleMemberType"}, key="'{getRoleTypeRoleMemberIds}' + 'roleId=' + #p0")
    public Set<String> getRoleTypeRoleMemberIds(@WebParam(name="roleId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findDelegateMembers")
    @WebResult(name="results")
    public DelegateMemberQueryResults findDelegateMembers(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDelegationMembersByDelegationId")
    @XmlElementWrapper(name="delegateMembers", required=true)
    @XmlElement(name="delegateMember", required=false)
    @WebResult(name="delegateMembers")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/DelegateMemberType"}, key="'delegateId=' + #p0")
    public List<DelegateMember> getDelegationMembersByDelegationId(@WebParam(name="delegateId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDelegationMemberByDelegationAndMemberId")
    @WebResult(name="delegateMember")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/DelegateMemberType"}, key="'delegationId=' + #p0 + '|' + 'memberId=' + #p1")
    public DelegateMember getDelegationMemberByDelegationAndMemberId(@WebParam(name="delegationId") String var1, @WebParam(name="memberId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDelegationMemberById")
    @WebResult(name="delegateMember")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/DelegateMemberType"}, key="'id=' + #p0")
    public DelegateMember getDelegationMemberById(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoleResponsibilities")
    @XmlElementWrapper(name="roleResponsibilities", required=true)
    @XmlElement(name="roleResponsibility", required=false)
    @WebResult(name="roleResponsibilities")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleResponsibilityType"}, key="'roleId=' + #p0")
    public List<RoleResponsibility> getRoleResponsibilities(@WebParam(name="roleId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRoleMemberResponsibilityActions")
    @XmlElementWrapper(name="roleResponsibilityActions", required=true)
    @XmlElement(name="roleResponsibilityAction", required=false)
    @WebResult(name="roleResponsibilityActions")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleResponsibilityType"}, key="'roleMemberId=' + #p0")
    public List<RoleResponsibilityAction> getRoleMemberResponsibilityActions(@WebParam(name="roleMemberId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDelegateTypeByRoleIdAndDelegateTypeCode")
    @WebResult(name="delegateType")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, key="'roleId=' + #p0 + '|' + 'delegateType=' + #p1")
    public DelegateType getDelegateTypeByRoleIdAndDelegateTypeCode(@WebParam(name="roleId") String var1, @WebParam(name="delegateType") DelegationType var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDelegateTypeByDelegationId")
    @WebResult(name="delegateType")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, key="'delegationId=' + #p0")
    public DelegateType getDelegateTypeByDelegationId(@WebParam(name="delegationId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="assignPrincipalToRole")
    @WebResult(name="roleMember")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public RoleMember assignPrincipalToRole(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="roleName") String var3, @WebParam(name="qualifications") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="assignGroupToRole")
    @WebResult(name="roleMember")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public RoleMember assignGroupToRole(@WebParam(name="groupId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="roleName") String var3, @WebParam(name="qualifications") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="assignRoleToRole")
    @WebResult(name="roleMember")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public RoleMember assignRoleToRole(@WebParam(name="roleId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="roleName") String var3, @WebParam(name="qualifications") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createRoleMember")
    @WebResult(name="roleMember")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public RoleMember createRoleMember(@WebParam(name="roleMember") RoleMember var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateRoleMember")
    @WebResult(name="roleMember")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public RoleMember updateRoleMember(@WebParam(name="roleMember") RoleMember var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateDelegateMember")
    @WebResult(name="delegateMember")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public DelegateMember updateDelegateMember(@WebParam(name="delegateMember") DelegateMember var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="createDelegateMember")
    @WebResult(name="delegateMember")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public DelegateMember createDelegateMember(@WebParam(name="delegateMember") DelegateMember var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="removeDelegateMembers")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public void removeDelegateMembers(@WebParam(name="delegateMembers") List<DelegateMember> var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="createRoleResponsibilityAction")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public RoleResponsibilityAction createRoleResponsibilityAction(@WebParam(name="roleResponsibilityAction") RoleResponsibilityAction var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateRoleResponsibilityAction")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public RoleResponsibilityAction updateRoleResponsibilityAction(@WebParam(name="roleResponsibilityAction") RoleResponsibilityAction var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="deleteRoleResponsibilityAction")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public void deleteRoleResponsibilityAction(@WebParam(name="roleResponsibilityActionId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createDelegateType")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public DelegateType createDelegateType(@WebParam(name="delegateType") DelegateType var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateDelegateType")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public DelegateType updateDelegateType(@WebParam(name="delegateType") DelegateType var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="removePrincipalFromRole")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public void removePrincipalFromRole(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="roleName") String var3, @WebParam(name="qualifications") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="removeGroupFromRole")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public void removeGroupFromRole(@WebParam(name="groupId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="roleName") String var3, @WebParam(name="qualifications") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="removeRoleFromRole")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public void removeRoleFromRole(@WebParam(name="roleId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="roleName") String var3, @WebParam(name="qualifications") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="assignPermissionToRole")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public void assignPermissionToRole(@WebParam(name="permissionId") String var1, @WebParam(name="roleId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="revokePermissionFromRole")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/RoleType", "http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/ResponsibilityType", "http://rice.kuali.org/kim/v2_0/RoleMembershipType", "http://rice.kuali.org/kim/v2_0/RoleMemberType", "http://rice.kuali.org/kim/v2_0/DelegateMemberType", "http://rice.kuali.org/kim/v2_0/RoleResponsibilityType", "http://rice.kuali.org/kim/v2_0/DelegateTypeType"}, allEntries=true)
    public void revokePermissionFromRole(@WebParam(name="permissionId") String var1, @WebParam(name="roleId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isDerivedRole")
    @WebResult(name="isDerivedRole")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleType"}, key="'{isDerivedRole}' + 'roleId=' + #p0")
    public boolean isDerivedRole(@WebParam(name="roleId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isDynamicRoleMembership")
    @WebResult(name="isDynamicRoleMembership")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/RoleType"}, key="'{isDynamicRoleMembership}' + 'roleId=' + #p0")
    public boolean isDynamicRoleMembership(@WebParam(name="roleId") String var1) throws RiceIllegalArgumentException;
}

