/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.type;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.common.attribute.KimAttribute;
import org.kuali.rice.kim.api.type.KimTypeAttributeContract;
import org.w3c.dom.Element;

@XmlRootElement(name="kimTypeAttribute")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="KimTypeAttributeType", propOrder={"id", "sortCode", "kimAttribute", "kimTypeId", "active", "versionNumber", "objectId", "_futureElements"})
public final class KimTypeAttribute
extends AbstractDataTransferObject
implements KimTypeAttributeContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="sortCode", required=false)
    private final String sortCode;
    @XmlElement(name="kimAttribute", required=false)
    private final KimAttribute kimAttribute;
    @XmlElement(name="kimTypeId", required=false)
    private final String kimTypeId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private KimTypeAttribute() {
        this.id = null;
        this.sortCode = null;
        this.kimAttribute = null;
        this.kimTypeId = null;
        this.active = false;
        this.versionNumber = 1L;
        this.objectId = null;
    }

    private KimTypeAttribute(Builder builder) {
        this.id = builder.getId();
        this.sortCode = builder.getSortCode();
        this.kimAttribute = builder.getKimAttribute() != null ? builder.getKimAttribute().build() : null;
        this.kimTypeId = builder.getKimTypeId();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getSortCode() {
        return this.sortCode;
    }

    @Override
    public KimAttribute getKimAttribute() {
        return this.kimAttribute;
    }

    @Override
    public String getKimTypeId() {
        return this.kimTypeId;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    static class Elements {
        static final String ID = "id";
        static final String SORT_CODE = "sortCode";
        static final String KIM_ATTRIBUTE = "kimAttribute";
        static final String KIM_TYPE_ID = "kimTypeId";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "kimTypeAttribute";
        static final String TYPE_NAME = "KimTypeAttributeType";

        Constants() {
        }
    }

    public static final class Builder
    implements KimTypeAttributeContract,
    ModelBuilder,
    Serializable {
        private String id;
        private String sortCode;
        private KimAttribute.Builder kimAttribute;
        private String kimTypeId;
        private boolean active;
        private Long versionNumber = 1L;
        private String objectId;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(KimTypeAttributeContract contract) {
            Builder builder = new Builder();
            builder.setId(contract.getId());
            builder.setSortCode(contract.getSortCode());
            if (contract.getKimAttribute() != null) {
                builder.setKimAttribute(KimAttribute.Builder.create(contract.getKimAttribute()));
            }
            builder.setKimTypeId(contract.getKimTypeId());
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getSortCode() {
            return this.sortCode;
        }

        public void setSortCode(String sortCode) {
            this.sortCode = sortCode;
        }

        @Override
        public KimAttribute.Builder getKimAttribute() {
            return this.kimAttribute;
        }

        public void setKimAttribute(KimAttribute.Builder kimAttribute) {
            this.kimAttribute = kimAttribute;
        }

        @Override
        public String getKimTypeId() {
            return this.kimTypeId;
        }

        public void setKimTypeId(String kimTypeId) {
            this.kimTypeId = kimTypeId;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            if (versionNumber != null && versionNumber <= 0L) {
                throw new IllegalArgumentException("versionNumber is invalid");
            }
            this.versionNumber = versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public KimTypeAttribute build() {
            return new KimTypeAttribute(this);
        }
    }
}

