/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.citizenship;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenshipContract;
import org.w3c.dom.Element;

@XmlRootElement(name="entityCitizenship")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityCitizenshipType", propOrder={"id", "entityId", "status", "countryCode", "startDate", "endDate", "versionNumber", "objectId", "active", "_futureElements"})
public final class EntityCitizenship
extends AbstractDataTransferObject
implements EntityCitizenshipContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="entityId", required=false)
    private final String entityId;
    @XmlElement(name="status", required=false)
    private final CodedAttribute status;
    @XmlElement(name="countryCode", required=false)
    private final String countryCode;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement(name="startDate", required=false)
    private final DateTime startDate;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement(name="endDate", required=false)
    private final DateTime endDate;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityCitizenship() {
        this.status = null;
        this.countryCode = null;
        this.startDate = null;
        this.endDate = null;
        this.versionNumber = null;
        this.objectId = null;
        this.active = false;
        this.id = null;
        this.entityId = null;
    }

    private EntityCitizenship(Builder builder) {
        this.status = builder.getStatus() != null ? builder.getStatus().build() : null;
        this.countryCode = builder.getCountryCode();
        this.startDate = builder.getStartDate();
        this.endDate = builder.getEndDate();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.active = builder.isActive();
        this.id = builder.getId();
        this.entityId = builder.getEntityId();
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public CodedAttribute getStatus() {
        return this.status;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public DateTime getStartDate() {
        return this.startDate;
    }

    @Override
    public DateTime getEndDate() {
        return this.endDate;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getId() {
        return this.id;
    }

    static class Elements {
        static final String ENTITY_ID = "entityId";
        static final String STATUS = "status";
        static final String COUNTRY_CODE = "countryCode";
        static final String START_DATE = "startDate";
        static final String END_DATE = "endDate";
        static final String ACTIVE = "active";
        static final String ID = "id";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityCitizenship";
        static final String TYPE_NAME = "EntityCitizenshipType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    EntityCitizenshipContract {
        private String entityId;
        private CodedAttribute.Builder status;
        private String countryCode;
        private DateTime startDate;
        private DateTime endDate;
        private Long versionNumber;
        private String objectId;
        private boolean active;
        private String id;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(EntityCitizenshipContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setEntityId(contract.getEntityId());
            if (contract.getStatus() != null) {
                builder.setStatus(CodedAttribute.Builder.create(contract.getStatus()));
            }
            builder.setCountryCode(contract.getCountryCode());
            builder.setStartDate(contract.getStartDate());
            builder.setEndDate(contract.getEndDate());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setActive(contract.isActive());
            builder.setId(contract.getId());
            return builder;
        }

        public EntityCitizenship build() {
            return new EntityCitizenship(this);
        }

        @Override
        public String getEntityId() {
            return this.entityId;
        }

        @Override
        public CodedAttribute.Builder getStatus() {
            return this.status;
        }

        @Override
        public String getCountryCode() {
            return this.countryCode;
        }

        @Override
        public DateTime getStartDate() {
            return this.startDate;
        }

        @Override
        public DateTime getEndDate() {
            return this.endDate;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getId() {
            return this.id;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public void setStatus(CodedAttribute.Builder status) {
            this.status = status;
        }

        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public void setStartDate(DateTime startDate) {
            this.startDate = startDate;
        }

        public void setEndDate(DateTime endDate) {
            this.endDate = endDate;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }
    }
}

