/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.identity;

import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.mo.common.Defaultable;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

import java.util.Collection;

public class EntityUtils {

    private EntityUtils() {
        throw new UnsupportedOperationException("do not call.");
    }

    public static <T extends Defaultable & Inactivatable> T getDefaultItem( Collection<T> collection ) {
		// find the default entry
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
		for ( T item : collection ) {
			if ( item.isDefaultValue() && item.isActive() ) {
				return (T)item;
			}
		}
		// if no default, return the first
		for ( T item : collection ) {
		    return item;
		}
		// if neither, return null
		return null;
	}
}
