/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.identity.external;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;

/**
 * an external identifier for a KIM identity
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface EntityExternalIdentifierContract extends Versioned, GloballyUnique, Identifiable {

    /**
     * Gets this id of the parent identity object.
     * @return the identity id for this {@link EntityEmailContract}
     */
    String getEntityId();

    /**
     * Gets this {@link EntityExternalIdentifierContract}'s type code.
     * @return the type code for this {@link EntityExternalIdentifierContract}, or null if none has been assigned.
     */
	String getExternalIdentifierTypeCode();

	/**
     * Gets this {@link EntityExternalIdentifierContract}'s type.
     * @return the type for this {@link EntityExternalIdentifierContract}, or null if none has been assigned.
     */
	EntityExternalIdentifierTypeContract getExternalIdentifierType();
	
	/**
     * Gets this {@link EntityExternalIdentifierContract}'s external id.
     * @return the external id for this {@link EntityExternalIdentifierContract}, or null if none has been assigned.
     */
	String getExternalId();
}
