/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.common.attribute;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.common.attribute.KimAttribute;
import org.kuali.rice.kim.api.common.attribute.KimAttributeDataContract;
import org.kuali.rice.kim.api.type.KimType;
import org.w3c.dom.Element;

@XmlRootElement(name="kimAttributeData")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="KimAttributeDataType", propOrder={"id", "assignedToId", "kimTypeId", "kimType", "kimAttribute", "attributeValue", "versionNumber", "objectId", "_futureElements"})
public final class KimAttributeData
extends AbstractDataTransferObject
implements KimAttributeDataContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="assignedToId", required=false)
    private final String assignedToId;
    @XmlElement(name="kimTypeId", required=true)
    private final String kimTypeId;
    @XmlElement(name="kimType", required=false)
    private final KimType kimType;
    @XmlElement(name="kimAttribute", required=false)
    private final KimAttribute kimAttribute;
    @XmlElement(name="attributeValue", required=false)
    private final String attributeValue;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private KimAttributeData() {
        this.id = null;
        this.assignedToId = null;
        this.kimTypeId = null;
        this.kimType = null;
        this.kimAttribute = null;
        this.attributeValue = null;
        this.versionNumber = null;
        this.objectId = null;
    }

    private KimAttributeData(Builder builder) {
        this.id = builder.getId();
        this.assignedToId = builder.getAssignedToId();
        this.kimTypeId = builder.getKimTypeId();
        this.kimType = builder.getKimType() != null ? builder.getKimType().build() : null;
        this.kimAttribute = builder.getKimAttribute() != null ? builder.getKimAttribute().build() : null;
        this.attributeValue = builder.getAttributeValue();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getAssignedToId() {
        return this.assignedToId;
    }

    @Override
    public String getKimTypeId() {
        return this.kimTypeId;
    }

    @Override
    public KimType getKimType() {
        return this.kimType;
    }

    @Override
    public KimAttribute getKimAttribute() {
        return this.kimAttribute;
    }

    @Override
    public String getAttributeValue() {
        return this.attributeValue;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public static final class Builder
    implements KimAttributeDataContract,
    ModelBuilder,
    Serializable {
        private String id;
        private String assignedToId;
        private String kimTypeId;
        private KimType.Builder kimType;
        private KimAttribute.Builder kimAttribute;
        private String attributeValue;
        private Long versionNumber;
        private String objectId;

        private Builder(String kimTypeId) {
            this.setKimTypeId(kimTypeId);
        }

        public static Builder create(String kimTypeId) {
            return new Builder(kimTypeId);
        }

        public static Builder create(KimAttributeDataContract contract) {
            Builder builder = new Builder(contract.getKimTypeId());
            builder.setAssignedToId(contract.getAssignedToId());
            builder.setId(contract.getId());
            if (contract.getKimAttribute() != null) {
                builder.setKimAttribute(KimAttribute.Builder.create(contract.getKimAttribute()));
            }
            if (contract.getKimType() != null) {
                builder.setKimType(KimType.Builder.create(contract.getKimType()));
            }
            builder.setValue(contract.getAttributeValue());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is whitespace");
            }
            this.id = id;
        }

        @Override
        public String getAssignedToId() {
            return this.assignedToId;
        }

        public void setAssignedToId(String assignedToId) {
            this.assignedToId = assignedToId;
        }

        @Override
        public String getKimTypeId() {
            return this.kimTypeId;
        }

        public void setKimTypeId(String kimTypeId) {
            this.kimTypeId = kimTypeId;
        }

        @Override
        public KimType.Builder getKimType() {
            return this.kimType;
        }

        public void setKimType(KimType.Builder kimType) {
            this.kimType = kimType;
        }

        @Override
        public KimAttribute.Builder getKimAttribute() {
            return this.kimAttribute;
        }

        public void setKimAttribute(KimAttribute.Builder kimAttribute) {
            this.kimAttribute = kimAttribute;
        }

        @Override
        public String getAttributeValue() {
            return this.attributeValue;
        }

        public void setValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public KimAttributeData build() {
            return new KimAttributeData(this);
        }
    }

    static class Elements {
        static final String ID = "id";
        static final String ASSIGNED_TO_ID = "assignedToId";
        static final String KIM_TYPE_ID = "kimTypeId";
        static final String KIM_TYPE = "kimType";
        static final String KIM_ATTRIBUTE = "kimAttribute";
        static final String ATTRIBUTE_VALUE = "attributeValue";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "kimAttributeData";
        static final String TYPE_NAME = "KimAttributeDataType";

        Constants() {
        }
    }
}

