/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.type;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoContract;
import org.w3c.dom.Element;

@XmlRootElement(name="entityTypeDataDefault")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityTypeDataDefaultType", propOrder={"entityTypeCode", "defaultAddress", "defaultEmailAddress", "defaultPhoneNumber", "_futureElements"})
public final class EntityTypeContactInfoDefault
extends AbstractDataTransferObject {
    @XmlElement(name="entityTypeCode", required=true)
    private final String entityTypeCode;
    @XmlElement(name="defaultAddress", required=false)
    private final EntityAddress defaultAddress;
    @XmlElement(name="defaultEmailAddress", required=false)
    private final EntityEmail defaultEmailAddress;
    @XmlElement(name="defaultPhoneNumber", required=false)
    private final EntityPhone defaultPhoneNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityTypeContactInfoDefault() {
        this.entityTypeCode = null;
        this.defaultAddress = null;
        this.defaultEmailAddress = null;
        this.defaultPhoneNumber = null;
    }

    public EntityTypeContactInfoDefault(String entityTypeCode, EntityAddress defaultAddress, EntityEmail defaultEmailAddress, EntityPhone defaultPhoneNumber) {
        this.entityTypeCode = entityTypeCode;
        this.defaultAddress = defaultAddress;
        this.defaultEmailAddress = defaultEmailAddress;
        this.defaultPhoneNumber = defaultPhoneNumber;
    }

    public EntityTypeContactInfoDefault(Builder builder) {
        this.entityTypeCode = builder.getEntityTypeCode();
        this.defaultAddress = builder.getDefaultAddress() == null ? null : builder.getDefaultAddress().build();
        this.defaultEmailAddress = builder.getDefaultEmailAddress() == null ? null : builder.getDefaultEmailAddress().build();
        this.defaultPhoneNumber = builder.getDefaultPhoneNumber() == null ? null : builder.getDefaultPhoneNumber().build();
    }

    public String getEntityTypeCode() {
        return this.entityTypeCode;
    }

    public EntityAddress getDefaultAddress() {
        return this.defaultAddress;
    }

    public EntityEmail getDefaultEmailAddress() {
        return this.defaultEmailAddress;
    }

    public EntityPhone getDefaultPhoneNumber() {
        return this.defaultPhoneNumber;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder {
        private String entityTypeCode;
        private EntityAddress.Builder defaultAddress;
        private EntityEmail.Builder defaultEmailAddress;
        private EntityPhone.Builder defaultPhoneNumber;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(EntityTypeContactInfoDefault immutable) {
            if (immutable == null) {
                throw new IllegalArgumentException("EntityTypeDataDefault is null");
            }
            Builder builder = new Builder();
            builder.setEntityTypeCode(immutable.entityTypeCode);
            if (immutable.getDefaultAddress() != null) {
                builder.setDefaultAddress(EntityAddress.Builder.create(immutable.getDefaultAddress()));
            }
            if (immutable.getDefaultEmailAddress() != null) {
                builder.setDefaultEmailAddress(EntityEmail.Builder.create(immutable.getDefaultEmailAddress()));
            }
            if (immutable.getDefaultPhoneNumber() != null) {
                builder.setDefaultPhoneNumber(EntityPhone.Builder.create(immutable.getDefaultPhoneNumber()));
            }
            return builder;
        }

        public static Builder create(EntityTypeContactInfoContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder();
            builder.setEntityTypeCode(contract.getEntityTypeCode());
            if (contract.getDefaultAddress() != null) {
                builder.setDefaultAddress(EntityAddress.Builder.create(contract.getDefaultAddress()));
            }
            if (contract.getDefaultEmailAddress() != null) {
                builder.setDefaultEmailAddress(EntityEmail.Builder.create(contract.getDefaultEmailAddress()));
            }
            if (contract.getDefaultPhoneNumber() != null) {
                builder.setDefaultPhoneNumber(EntityPhone.Builder.create(contract.getDefaultPhoneNumber()));
            }
            return builder;
        }

        public EntityTypeContactInfoDefault build() {
            return new EntityTypeContactInfoDefault(this);
        }

        public String getEntityTypeCode() {
            return this.entityTypeCode;
        }

        public void setEntityTypeCode(String entityTypeCode) {
            this.entityTypeCode = entityTypeCode;
        }

        public EntityAddress.Builder getDefaultAddress() {
            return this.defaultAddress;
        }

        public void setDefaultAddress(EntityAddress.Builder defaultAddress) {
            this.defaultAddress = defaultAddress;
        }

        public EntityEmail.Builder getDefaultEmailAddress() {
            return this.defaultEmailAddress;
        }

        public void setDefaultEmailAddress(EntityEmail.Builder defaultEmailAddress) {
            this.defaultEmailAddress = defaultEmailAddress;
        }

        public EntityPhone.Builder getDefaultPhoneNumber() {
            return this.defaultPhoneNumber;
        }

        public void setDefaultPhoneNumber(EntityPhone.Builder defaultPhoneNumber) {
            this.defaultPhoneNumber = defaultPhoneNumber;
        }
    }

    static class Elements {
        static final String ENTITY_TYPE_CODE = "entityTypeCode";
        static final String DEFAULT_ADDRESS = "defaultAddress";
        static final String DEFAULT_EMAIL_ADDRESS = "defaultEmailAddress";
        static final String DEFAULT_PHONE_NUMBER = "defaultPhoneNumber";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityTypeDataDefault";
        static final String TYPE_NAME = "EntityTypeDataDefaultType";

        Constants() {
        }
    }
}

