/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.identity;

import javax.servlet.http.HttpServletRequest;

/**
 * This service is used to extract the name of the authenticated principal from
 * an incoming http request.  Depending on the implementation of this service,
 * it may extract information from a request which has already been authenticated
 * (i.e. via another service like CAS or Shiboleth).  Alternatively, this
 * implementation might actually perform the authentication itself based on
 * information available on the http request.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * 
 */
public interface AuthenticationService {
	
	/**
	 * Returns the principalName of the principal that has authenticated with
	 * the incoming HttpServletRequest.  Implementations of this method might
	 * perform actual authentication or merely extract the existing
	 * authenticated principal's name off of the incoming request.
	 * 
	 * @param request the incoming HttpServletRequest
	 * @return the principalName of the authenticated principal, or null if
	 * the principal could not be authenticated
	 */
    String getPrincipalName(HttpServletRequest request);
}
