/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.identity.principal;


import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
/**
 * This is a contract for Principal.
 *
 * A principal represents an entity that can authenticate. A principal has an ID that is
 * used to uniquely identify it. It also has a name that represents the principal's username.
 * All principals are associated with one and only one entity.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface PrincipalContract extends Inactivatable, Versioned, GloballyUnique {
   /**
     * Gets this {@link PrincipalContract}'s id.
     * @return the id for this {@link PrincipalContract}, or null if none has been assigned.
     */
	String getPrincipalId();
	
	/**
     * Gets this {@link PrincipalContract}'s name.
     * @return the name for this {@link PrincipalContract}, this value cannot be null.
     */
	String getPrincipalName();
	
	/**
     * Gets this {@link PrincipalContract}'s identity id.
     * @return the identity id for this {@link PrincipalContract}, or null if none has been assigned.
     */
	String getEntityId();
	
}
