/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api;

import org.kuali.rice.core.api.CoreConstants;
import org.kuali.rice.core.api.CoreConstants.Versions;

public final class KimApiConstants {
    public static final class Namespaces {

        public static final String MODULE_NAME = "kim";

    	public static final String KIM_NAMESPACE_PREFIX = CoreConstants.Namespaces.ROOT_NAMESPACE_PREFIX + "/" + MODULE_NAME;

    	/**
    	 * Namespace for the core module which is compatible with Kuali Rice 2.0.x.
    	 */
    	public static final String KIM_NAMESPACE_2_0 = KIM_NAMESPACE_PREFIX + "/" + Versions.VERSION_2_0;

        private Namespaces() {
		    throw new UnsupportedOperationException("do not call");
	    }
    }

    public static final class Cache {
        public static final String KIM_DISTRIBUTED_CACHE_MANAGER = "kimDistributedCacheManager";
    }
    public static final class ServiceNames {

        public static final String ROLE_SERVICE_SOAP = "roleService";
        public static final String GROUP_SERVICE_SOAP = "groupService";
        public static final String IDENTITY_SERVICE_SOAP = "identityService";
    }

    public static final class RestrictedMasks {
        public static final String RESTRICTED_DATA_MASK = "Xxxxxx";
        public static final String RESTRICTED_DATA_MASK_CODE = "XX";
        public static final String RESTRICTED_DATA_MASK_ZIP = "00000";
        public static final String RESTRICTED_DATA_MASK_PHONE = "000-000-0000";
    }
}
