/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.group;


import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.InactivatableFromTo;
/**
 *
 * This is a contract for a GroupMember
 *
 * A principal or group is considered to be a "member" of a group if it is either directly assigned to the group or
 * indirectly assigned (via a nested group membership).
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface GroupMemberContract extends Versioned, GloballyUnique, InactivatableFromTo, Identifiable {

    /**
     * This is the id for the Group.
     *
     * <p>
     * This is a id assigned to a Group.  It defines the group this group member belongs to.
     * </p>
     *
     * @return groupId
     */
    String getGroupId();

    /**
     * This is the member id for the Group Member.
     *
     * <p>
     * This is a id value that defines the Group Member.  This value is either a Principal Id or Group Id
     * depending on the type code
     * </p>
     *
     * @return memberId
     */
    String getMemberId();

    /**
     * This is the type code for the Group Member.
     *
     * <p>
     * This is a value that defines the type of Group Member.  This value determines whether memberId is
     * either a Principal Id or Group Id
     * </p>
     *
     * @return typeCode
     */
    MemberType getType();
}
