/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.identity.personal;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;

/**
 * ethnicity information for a KIM identity
 * 
 * @author Kuali Rice Team (kuali-rice@googlegroups.com)
 *
 */
public interface EntityEthnicityContract extends Versioned, GloballyUnique, Identifiable {
	
	/**
     * Gets this {@link EntityEthnicityContract}'s identity id.
     * @return the identity id for this {@link EntityEthnicityContract}, or null if none has been assigned.
     */
	String getEntityId();
	
	/**
     * Gets this {@link EntityEthnicityContract}'s ethnicity code.
     * @return the ethnicity code for this {@link EntityEthnicityContract}, or null if none has been assigned.
     */
	String getEthnicityCode();
	
	/**
     * Gets this {@link EntityEthnicityContract}'s unmasked ethnicity code.
     * @return the unmasked ethnicity code for this {@link EntityEthnicityContract}, or null if none has been assigned.
     */
	String getEthnicityCodeUnmasked();
	
	/**
     * Gets this {@link EntityEthnicityContract}'s sub-ethnicity code.
     * @return the sub-ethnicity code for this {@link EntityEthnicityContract}, or null if none has been assigned.
     */
	String getSubEthnicityCode();
	
	/**
     * Gets this {@link EntityEthnicityContract}'s unmasked sub-ethnicity code.
     * @return the unmasked sub-ethnicity code for this {@link EntityEthnicityContract}, or null if none has been assigned.
     */
    String getSubEthnicityCodeUnmasked();

    /**
     * Returns a boolean value that determines if personal fields should be suppressed.
     * @return boolean value that determines if personal fields should be suppressed.
     */
	boolean isSuppressPersonal();
}
