/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.common.attribute;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * This is the contract for a KimAttribute.  A KimAttribute
 * associates categorizes an attribute and describes how to
 * find the attribute for the purpose of the kns.
 */
public interface KimAttributeContract extends Versioned, GloballyUnique, Identifiable, Inactivatable {

    /**
     * A fully-qualified class name which contains the {@link #getAttributeName()}.    This cannot be null or a blank string.
     *
     * @return the name
     */
    String getComponentName();

    /**
     * The name of the attribute on the {@link #getComponentName()}.   This cannot be null or a blank string.
     *
     * @return the name
     */
    String getAttributeName();

    /**
     * The namespace code that this kim attribute belongs too.   This cannot be null or a blank string.
     *
     * @return namespace code
     */
    String getNamespaceCode();

    /**
     * The label for the kim attribute.  This is optional and can be null or blank.
     *
     * @return the label
     */
    String getAttributeLabel();
}
