/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.framework.group;

import java.util.Map;

import org.kuali.rice.kim.api.group.GroupContract;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

/**
 * TODO: Likely should remove all methods from this interface after KULRICE-7170 is fixed
 */
public interface GroupEbo extends GroupContract, ExternalizableBusinessObject {
    
    /**
     * This is the namespace code for the Group.
     *
     * <p>
     * This is a namespace code assigned to a Group.  Together with name, it makes up another unique identifier for Group
     * </p>
     *
     * @return namespaceCode
     */
    @Override
    String getNamespaceCode();

    /**
     * This is the name for the Group.
     *
     * <p>
     * This is a name assigned to a Group.  Together with NamespaceCode, it makes up another unique identifier for Group
     * </p>
     *
     * @return name
     */
    @Override
    String getName();

    /**
     * This a description for the Group.
     *
     * <p>
     * This is a description assigned to a Group.
     * </p>
     *
     * @return description
     */
    @Override
    String getDescription();

    /**
     * This a Kim Type Id for the Group.
     *
     * <p>
     * This links a Kim Type to the Group to allow custom types of Groups.
     * </p>
     *
     * @return description
     */
    @Override
    String getKimTypeId();

    /**
     * This is a set of Attributes for a Group.
     *
     * <p>
     * This is a set of attributes which are key-label pairs that are defined by the Group's Kim Type.
     * </p>
     *
     * @return attributes
     */
    @Override
    Map<String, String> getAttributes();
    
    /**
     * The unique identifier for an object.  This can be null.
     *
     * @return the id
     */
    @Override
    String getId();
    
    /**
     * Returns the version number for this object.  In general, this value should only
     * be null if the object has not yet been stored to a persistent data store.
     * This version number is generally used for the purposes of optimistic locking.
     * 
     * @return the version number, or null if one has not been assigned yet
     */
    @Override
    Long getVersionNumber();
    
    /**
     * Return the globally unique object id of this object.  In general, this value should only
     * be null if the object has not yet been stored to a persistent data store.
     * 
     * @return the objectId of this object, or null if it has not been set yet
     */
    @Override
    String getObjectId();
    
    /**
     * The active indicator for an object.
     *
     * @return true if active false if not.
     */
    @Override
    boolean isActive();
}
