/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.framework.services;

import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeUtils;
import org.kuali.rice.kim.framework.type.KimTypeService;

public class KimFrameworkServiceLocator {
    private static final Logger LOG = LogManager.getLogger(KimFrameworkServiceLocator.class);

    public static KimTypeService getKimTypeService(KimType kimType) {
        if (kimType == null) {
            throw new IllegalArgumentException("Invalid service name passed, value was null.");
        }
        return KimFrameworkServiceLocator.getKimTypeService(KimTypeUtils.resolveKimTypeServiceName((String)kimType.getServiceName()));
    }

    public static KimTypeService getKimTypeService(QName kimTypeServiceName) {
        if (kimTypeServiceName == null) {
            throw new IllegalArgumentException("Invalid service name passed, value was null.");
        }
        try {
            return (KimTypeService)GlobalResourceLoader.getService((QName)kimTypeServiceName);
        }
        catch (Exception exception) {
            LOG.error("Unable to find KIM type service with name: " + kimTypeServiceName, (Throwable)exception);
            return null;
        }
    }
}

