/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.framework.role;

import org.kuali.rice.kim.api.role.RoleContract;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

/**
 * TODO: Likely should remove all methods from this interface after KULRICE-7170 is fixed
 */
public interface RoleEbo extends RoleContract, ExternalizableBusinessObject {
    
    /**
     * A namespace for this role.  A namespace for a role identifies the system/module to which this role applies.
     *
     * @return Namespace for the role.
     */
    @Override
    String getNamespaceCode();

    /**
     * The human readable name for this role.
     *
     * @return Human readable role name.
     */
    @Override
    String getName();

    /**
     * A full textual description of this role.  This String should provide a verbose description of the role, what
     * it is meant to provide to principals assigned to it, and what permissions it implies.
     *
     * @return Description of the role.
     */
    @Override
    String getDescription();

    /**
     * Provides the associated KimType identifier for this role.  This controls what additional attributes
     * are available.
     *
     * @return KimType Id
     */
    @Override
    String getKimTypeId();
    
    /**
     * Returns the version number for this object.  In general, this value should only
     * be null if the object has not yet been stored to a persistent data store.
     * This version number is generally used for the purposes of optimistic locking.
     * 
     * @return the version number, or null if one has not been assigned yet
     */
    @Override
    Long getVersionNumber();
    
    /**
     * The unique identifier for an object.  This can be null.
     *
     * @return the id
     */
    @Override
    String getId();
    
    /**
     * The active indicator for an object.
     *
     * @return true if active false if not.
     */
    @Override
    boolean isActive();
    
    /**
     * Return the globally unique object id of this object.  In general, this value should only
     * be null if the object has not yet been stored to a persistent data store.
     * 
     * @return the objectId of this object, or null if it has not been set yet
     */
    @Override
    String getObjectId();
}
