/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.group;

import org.kuali.rice.kim.impl.group.GroupBo;

import java.util.List;


/**
 * Provides internal notification services for the GroupServiceImpl.  It
 * specifically allows GroupServiceImpl to notify interested parties that
 * a group's membership has changed.  
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface GroupInternalService {
	/**
	 * Save the GroupBo, being careful to reset the action document
	 * assignments based on any membership changes.
	 * 
	 * @param group
	 */
    public GroupBo saveWorkgroup(GroupBo group);

    /**
     * Updates KEW for workgroup members according to membership differences between the
     * two workgroups.  Since the changeset of such an operation could potentially be quite large,
     * this method should schedule the changes to occur asynchronously to mitigate transaction
     * and concurrent document modification issues.
     */
    public void updateForWorkgroupChange( String groupId,
    		List<String> oldPrincipalIds, List<String> newPrincipalIds);

    /**
     * Updates KEW for a the given document for a user who was added to a Group.  This method will generate
     * new action items for the requests on the document which are for the Group.  This method will also verify that
     * the user is, in fact, still a member of the Group at the time of the invocation of this method before
     * generating the action items.
     */
    public void updateForUserAddedToGroup(String principalId, String groupId);

    /**
     * Updates KEW for a the given document for a user who was removed from a Group.  This will delete
     * any action items for the given user on the document which were sent to that user because they were a
     * member of the Group.  This method will also verify that the user is still no longer a member of the Group
     * at the time of the method invocation before removing the action items.
     */
    public void updateForUserRemovedFromGroup(String principalId, String groupId);
}
