/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.KIMPropertyConstants;
import org.kuali.rice.krad.lookup.LookupableImpl;
import org.kuali.rice.krad.lookup.LookupForm;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Custom lookupable for the {@link PersonImpl} lookup to call the person service for searching
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class PersonLookupableImpl extends LookupableImpl {
    private static final long serialVersionUID = -3149952849854425077L;

    /**
     * Lower cases criteria on principal name and calls the person service to carry out the search
     *
     */
    @Override
    protected Collection<?> executeSearch(Map<String, String> adjustedSearchCriteria,
                List<String> wildcardAsLiteralSearchCriteria, boolean bounded, Integer searchResultsLimit) {
        // lower case principal name
        if (adjustedSearchCriteria != null && StringUtils.isNotEmpty(adjustedSearchCriteria.get(
                KIMPropertyConstants.Person.PRINCIPAL_NAME))) {
            adjustedSearchCriteria.put(KIMPropertyConstants.Person.PRINCIPAL_NAME, adjustedSearchCriteria.get(
                    KIMPropertyConstants.Person.PRINCIPAL_NAME).toLowerCase());
        }

        return getPersonService().findPeople(adjustedSearchCriteria, !bounded);
    }

    public PersonService getPersonService() {
        return KimApiServiceLocator.getPersonService();
    }
}
