/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity.employment;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.framework.identity.employment.EntityEmploymentTypeEbo;
import org.kuali.rice.kim.impl.identity.CodedAttributeBo;

@AttributeOverrides({ @AttributeOverride(name = "code", column = @Column(name = "EMP_TYP_CD")) })
@Entity
@Table(name = "KRIM_EMP_TYP_T")
public class EntityEmploymentTypeBo extends CodedAttributeBo implements EntityEmploymentTypeEbo {

    private static final long serialVersionUID = -5365214631480350557L;

    public static EntityEmploymentTypeBo from(CodedAttribute immutable) {
        return CodedAttributeBo.from(EntityEmploymentTypeBo.class, immutable);
    }
}
