/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity.external;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierType;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierTypeContract;
import org.kuali.rice.kim.framework.identity.external.EntityExternalIdentifierTypeEbo;
import org.kuali.rice.kim.impl.identity.CodedAttributeBo;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@AttributeOverrides({ @AttributeOverride(name = "code", column = @Column(name = "EXT_ID_TYP_CD")) })
@Entity
@Table(name = "KRIM_EXT_ID_TYP_T")
public class EntityExternalIdentifierTypeBo extends CodedAttributeBo implements EntityExternalIdentifierTypeEbo, EntityExternalIdentifierTypeContract {

    private static final long serialVersionUID = 1058518958597912170L;

    @Column(name = "ENCR_REQ_IND")
    @Convert(converter = BooleanYNConverter.class)
    private boolean encryptionRequired;

    @Override
    public boolean isEncryptionRequired() {
        return encryptionRequired;
    }

    public void setEncryptionRequired(boolean encryptionRequired) {
        this.encryptionRequired = encryptionRequired;
    }

    public static EntityExternalIdentifierTypeBo from(EntityExternalIdentifierType immutable) {
        EntityExternalIdentifierTypeBo bo = CodedAttributeBo.from(EntityExternalIdentifierTypeBo.class, CodedAttribute.Builder.create(immutable).build());
        bo.setEncryptionRequired(immutable.isEncryptionRequired());
        return bo;
    }

    public static EntityExternalIdentifierType to(EntityExternalIdentifierTypeBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityExternalIdentifierType.Builder.create(bo).build();
    }
}
