/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity.phone;

import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name = "KRIM_ENTITY_PHONE_T")
public class EntityPhoneBo extends EntityPhoneBase {
    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(generator = "KRIM_ENTITY_PHONE_ID_S")
    @PortableSequenceGenerator(name = "KRIM_ENTITY_PHONE_ID_S")
    @Column(name = "ENTITY_PHONE_ID")
    private String id;

    @JoinFetch(value= JoinFetchType.OUTER)
    @ManyToOne(targetEntity = EntityPhoneTypeBo.class, fetch = FetchType.EAGER, cascade = {})
    @JoinColumn(name = "PHONE_TYP_CD", insertable = false, updatable = false)
    private EntityPhoneTypeBo phoneType;

    public static EntityPhone to(EntityPhoneBo bo) {
        if (bo == null) {
            return null;
        }

        return EntityPhone.Builder.create(bo).build();
    }

    /**
     * Creates a CountryBo business object from an immutable representation of a Country.
     *
     * @param immutable immutable Country
     * @return a CountryBo
     */
    public static EntityPhoneBo from(EntityPhone immutable) {
        if (immutable == null) {
            return null;
        }

        EntityPhoneBo bo = new EntityPhoneBo();
        bo.setId(immutable.getId());
        bo.setActive(immutable.isActive());

        bo.setEntityId(immutable.getEntityId());
        bo.setEntityTypeCode(immutable.getEntityTypeCode());
        if (immutable.getPhoneType() != null) {
            bo.setPhoneTypeCode(immutable.getPhoneType().getCode());
        }

        bo.setPhoneType(EntityPhoneTypeBo.from(immutable.getPhoneType()));
        bo.setDefaultValue(immutable.isDefaultValue());
        bo.setCountryCode(immutable.getCountryCodeUnmasked());
        bo.setPhoneNumber(immutable.getPhoneNumberUnmasked());
        bo.setExtensionNumber(immutable.getExtensionNumberUnmasked());
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setObjectId(immutable.getObjectId());

        return bo;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public EntityPhoneTypeBo getPhoneType() {
        return this.phoneType;
    }

    public void setPhoneType(EntityPhoneTypeBo phoneType) {
        this.phoneType = phoneType;
    }


}
