/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.ldap;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.util.BufferedLogger;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.ldap.BaseMapper;
import org.springframework.ldap.core.DirContextOperations;

public class EntityAffiliationMapper
extends BaseMapper<List<EntityAffiliation>> {
    @Override
    List<EntityAffiliation> mapDtoFromContext(DirContextOperations context) {
        List<EntityAffiliation.Builder> builders = this.mapBuilderFromContext(context);
        ArrayList<EntityAffiliation> affiliations = new ArrayList<EntityAffiliation>();
        if (builders != null) {
            for (EntityAffiliation.Builder builder : builders) {
                affiliations.add(builder.build());
            }
        }
        return affiliations;
    }

    List<EntityAffiliation.Builder> mapBuilderFromContext(DirContextOperations context) {
        ArrayList<EntityAffiliation.Builder> retval = new ArrayList<EntityAffiliation.Builder>();
        String primaryAffiliationProperty = this.getConstants().getPrimaryAffiliationLdapProperty();
        String affiliationProperty = this.getConstants().getAffiliationLdapProperty();
        BufferedLogger.debug("Got affiliation ", context.getStringAttribute(primaryAffiliationProperty));
        BufferedLogger.debug("Got affiliation ", context.getStringAttribute(affiliationProperty));
        String primaryAffiliation = context.getStringAttribute(primaryAffiliationProperty);
        int affiliationId = 1;
        String affiliationCode = this.getAffiliationTypeCodeForName(primaryAffiliation);
        EntityAffiliation.Builder aff1 = EntityAffiliation.Builder.create();
        aff1.setAffiliationType(EntityAffiliationType.Builder.create((String)(affiliationCode == null ? "AFLT" : affiliationCode)));
        aff1.setCampusCode(this.getConstants().getDefaultCampusCode());
        aff1.setId("" + affiliationId++);
        aff1.setDefaultValue(true);
        aff1.setActive(true);
        retval.add(aff1);
        String[] affiliations = context.getStringAttributes(affiliationProperty);
        if (affiliations == null) {
            affiliations = new String[]{};
        }
        for (String affiliation : affiliations) {
            if (StringUtils.equals((String)affiliation, (String)primaryAffiliation) || (affiliationCode = this.getAffiliationTypeCodeForName(affiliation)) == null || this.hasAffiliation(retval, affiliationCode)) continue;
            EntityAffiliation.Builder aff = EntityAffiliation.Builder.create();
            aff.setAffiliationType(EntityAffiliationType.Builder.create((String)affiliationCode));
            aff.setCampusCode(this.getConstants().getDefaultCampusCode());
            aff.setId("" + affiliationId++);
            aff.setDefaultValue(false);
            aff.setActive(true);
            retval.add(aff);
        }
        return retval;
    }

    protected String getAffiliationTypeCodeForName(String affiliationName) {
        String[] mappings;
        for (String affilMap : mappings = this.getConstants().getAffiliationMappings().split(",")) {
            if (!StringUtils.contains((String)affilMap, (String)affiliationName)) continue;
            return affilMap.split("=")[1];
        }
        return null;
    }

    protected boolean hasAffiliation(List<EntityAffiliation.Builder> affiliations, String affiliationCode) {
        for (EntityAffiliation.Builder affiliation : affiliations) {
            if (!StringUtils.equalsIgnoreCase((String)affiliation.getAffiliationType().getCode(), (String)affiliationCode)) continue;
            return true;
        }
        return false;
    }
}

