/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.ldap;

import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.ldap.BaseMapper;
import org.springframework.ldap.core.DirContextOperations;

public class EntityNameMapper
extends BaseMapper<EntityName> {
    @Override
    EntityName mapDtoFromContext(DirContextOperations context) {
        return this.mapDtoFromContext(context, true);
    }

    EntityName mapDtoFromContext(DirContextOperations context, boolean isdefault) {
        EntityName.Builder builder = this.mapBuilderFromContext(context, isdefault);
        return builder != null ? builder.build() : null;
    }

    EntityName.Builder mapBuilderFromContext(DirContextOperations context) {
        return this.mapBuilderFromContext(context, true);
    }

    EntityName.Builder mapBuilderFromContext(DirContextOperations context, boolean isdefault) {
        EntityName.Builder person = EntityName.Builder.create();
        person.setEntityId(context.getStringAttribute(this.getConstants().getKimLdapIdProperty()));
        person.setId(context.getStringAttribute(this.getConstants().getKimLdapIdProperty()));
        String fullName = context.getStringAttribute(this.getConstants().getGivenNameLdapProperty());
        if (fullName != null) {
            String[] name = fullName.split(" ");
            person.setFirstName(name[0]);
            if (name.length > 1) {
                person.setMiddleName(name[1]);
            }
        } else {
            person.setFirstName(fullName);
        }
        person.setLastName(context.getStringAttribute(this.getConstants().getSnLdapProperty()));
        person.setDefaultValue(isdefault);
        person.setActive(true);
        person.setNameType(CodedAttribute.Builder.create((String)"PRI"));
        return person;
    }
}

