/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.ldap;

import java.util.ArrayList;
import org.kuali.rice.core.util.BufferedLogger;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.ldap.BaseMapper;
import org.kuali.rice.kim.ldap.EntityAddressMapper;
import org.kuali.rice.kim.ldap.EntityEmailMapper;
import org.kuali.rice.kim.ldap.EntityPhoneMapper;
import org.springframework.ldap.core.DirContextOperations;

public class EntityTypeContactInfoMapper
extends BaseMapper<EntityTypeContactInfo> {
    private EntityAddressMapper addressMapper;
    private EntityPhoneMapper phoneMapper;
    private EntityEmailMapper emailMapper;

    @Override
    EntityTypeContactInfo mapDtoFromContext(DirContextOperations context) {
        EntityTypeContactInfo.Builder builder = this.mapBuilderFromContext(context);
        return builder != null ? builder.build() : null;
    }

    EntityTypeContactInfo.Builder mapBuilderFromContext(DirContextOperations context) {
        String entityId = context.getStringAttribute(this.getConstants().getKimLdapIdProperty());
        String entityTypeCode = this.getConstants().getPersonEntityTypeCode();
        EntityTypeContactInfo.Builder builder = EntityTypeContactInfo.Builder.create((String)entityId, (String)entityTypeCode);
        EntityAddress.Builder address = this.getAddressMapper().mapBuilderFromContext(context);
        ArrayList<EntityAddress.Builder> addresses = new ArrayList<EntityAddress.Builder>();
        addresses.add(address);
        ArrayList<EntityEmail.Builder> email = new ArrayList<EntityEmail.Builder>();
        email.add(this.getEmailMapper().mapBuilderFromContext(context));
        ArrayList<EntityPhone.Builder> phone = new ArrayList<EntityPhone.Builder>();
        phone.add(this.getPhoneMapper().mapBuilderFromContext(context));
        builder.setAddresses(addresses);
        builder.setEmailAddresses(email);
        builder.setPhoneNumbers(phone);
        BufferedLogger.debug("Created Entity Type with code ", builder.getEntityTypeCode());
        return builder;
    }

    public final EntityAddressMapper getAddressMapper() {
        return this.addressMapper;
    }

    public final void setAddressMapper(EntityAddressMapper argAddressMapper) {
        this.addressMapper = argAddressMapper;
    }

    public final EntityPhoneMapper getPhoneMapper() {
        return this.phoneMapper;
    }

    public final void setPhoneMapper(EntityPhoneMapper argPhoneMapper) {
        this.phoneMapper = argPhoneMapper;
    }

    public final EntityEmailMapper getEmailMapper() {
        return this.emailMapper;
    }

    public final void setEmailMapper(EntityEmailMapper argEmailMapper) {
        this.emailMapper = argEmailMapper;
    }
}

