/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.ldap;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.util.BufferedLogger;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.ldap.BaseMapper;
import org.kuali.rice.kim.ldap.InvalidLdapEntityException;
import org.springframework.ldap.core.DirContextOperations;

public class PrincipalMapper
extends BaseMapper<Principal> {
    private ParameterService parameterService;

    @Override
    Principal mapDtoFromContext(DirContextOperations context) {
        Principal.Builder builder = this.mapBuilderFromContext(context);
        return builder != null ? builder.build() : null;
    }

    Principal.Builder mapBuilderFromContext(DirContextOperations context) {
        String entityId = context.getStringAttribute(this.getConstants().getKimLdapIdProperty());
        String principalName = context.getStringAttribute(this.getConstants().getKimLdapNameProperty());
        Principal.Builder person = Principal.Builder.create((String)principalName);
        if (entityId == null) {
            throw new InvalidLdapEntityException("LDAP Search Results yielded an invalid result with attributes " + context.getAttributes());
        }
        person.setPrincipalId(entityId);
        person.setEntityId(entityId);
        person.setActive(this.isPersonActive(context));
        return person;
    }

    protected boolean isPersonActive(DirContextOperations context) {
        block4: {
            String[] affils = context.getStringAttributes(this.getConstants().getAffiliationLdapProperty());
            Object edsVal = this.getLdapValue("principals.active.Y");
            if (affils == null || affils.length <= 0 || edsVal == null) break block4;
            if (edsVal instanceof List) {
                List edsValLst = (List)edsVal;
                for (String affil : affils) {
                    if (!edsValLst.contains(affil)) continue;
                    return true;
                }
            } else {
                String edsValStr = (String)edsVal;
                for (String affil : affils) {
                    if (!StringUtils.equals((String)affil, (String)edsValStr)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected Object getLdapValue(String kimAttribute) {
        Matcher matcher = this.getKimAttributeMatcher(kimAttribute);
        BufferedLogger.debug("Does ", kimAttribute, " match? ", matcher.matches());
        if (!matcher.matches()) {
            return null;
        }
        String value = matcher.group(2);
        if (value.contains(",")) {
            return Arrays.asList(value.split(","));
        }
        return value;
    }

    protected Matcher getKimAttributeMatcher(String kimAttribute) {
        String mappedParamValue = this.getParameterService().getParameterValueAsString(this.getConstants().getParameterNamespaceCode(), this.getConstants().getParameterDetailTypeCode(), this.getConstants().getMappedParameterName());
        String regexStr = String.format("(%s|.*;%s)=([^=;]*).*", kimAttribute, kimAttribute);
        BufferedLogger.debug("Matching KIM attribute with regex ", regexStr);
        Matcher retval = Pattern.compile(regexStr).matcher(mappedParamValue);
        if (!retval.matches()) {
            mappedParamValue = this.getParameterService().getParameterValueAsString(this.getConstants().getParameterNamespaceCode(), this.getConstants().getParameterDetailTypeCode(), this.getConstants().getMappedValuesName());
            retval = Pattern.compile(regexStr).matcher(mappedParamValue);
        }
        return retval;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService service) {
        this.parameterService = service;
    }
}

