/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.ldap;

import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.ldap.BaseMapper;
import org.springframework.ldap.core.DirContextOperations;

public class EntityEmploymentMapper
extends BaseMapper<EntityEmployment> {
    @Override
    EntityEmployment mapDtoFromContext(DirContextOperations context) {
        EntityEmployment.Builder builder = this.mapBuilderFromContext(context);
        return builder != null ? builder.build() : null;
    }

    EntityEmployment.Builder mapBuilderFromContext(DirContextOperations context) {
        String departmentCode = context.getStringAttribute(this.getConstants().getDepartmentLdapProperty());
        if (departmentCode == null) {
            return null;
        }
        EntityEmployment.Builder employee = EntityEmployment.Builder.create();
        employee.setId(context.getStringAttribute(this.getConstants().getEmployeeIdProperty()));
        employee.setEmployeeStatus(CodedAttribute.Builder.create((String)context.getStringAttribute(this.getConstants().getEmployeeStatusProperty())));
        employee.setEmployeeType(CodedAttribute.Builder.create((String)"P"));
        employee.setBaseSalaryAmount(KualiDecimal.ZERO);
        employee.setActive(true);
        return employee;
    }
}

