/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class BufferedLogger {
    private static final CharSequence getMessage(Object ... objs) {
        StringBuilder retval = new StringBuilder();
        for (Object obj : objs) {
            retval.append(obj);
        }
        return retval;
    }

    private static final Logger getLogger() {
        try {
            return Logger.getLogger(Class.forName(new Throwable().getStackTrace()[2].getClassName()));
        }
        catch (Exception e) {
            return Logger.getLogger(BufferedLogger.class);
        }
    }

    public static final Logger logger() {
        try {
            return Logger.getLogger(Class.forName(new Throwable().getStackTrace()[1].getClassName()));
        }
        catch (Exception e) {
            return Logger.getLogger(BufferedLogger.class);
        }
    }

    public static final void trace(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isTraceEnabled()) {
            log.trace((Object)BufferedLogger.getMessage(objs));
        }
    }

    public static final void debug(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isDebugEnabled()) {
            log.debug((Object)BufferedLogger.getMessage(objs));
        }
    }

    public static final void info(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isInfoEnabled()) {
            log.info((Object)BufferedLogger.getMessage(objs));
        }
    }

    public static final void warn(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isEnabledFor((Priority)Level.WARN)) {
            log.warn((Object)BufferedLogger.getMessage(objs));
        }
    }

    public static final void error(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isEnabledFor((Priority)Level.ERROR)) {
            BufferedLogger.getLogger().error((Object)BufferedLogger.getMessage(objs));
        }
    }

    public static final void fatal(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isEnabledFor((Priority)Level.FATAL)) {
            log.fatal((Object)BufferedLogger.getMessage(objs));
        }
    }
}

